/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_resource_binding")
public class SpvcMslResourceBinding
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGE;
    public static final int DESC_SET;
    public static final int BINDING;
    public static final int MSL_BUFFER;
    public static final int MSL_TEXTURE;
    public static final int MSL_SAMPLER;

    public SpvcMslResourceBinding(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), SpvcMslResourceBinding.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvExecutionModel")
    public int stage() {
        return SpvcMslResourceBinding.nstage(this.address());
    }

    @NativeType(value="unsigned int")
    public int desc_set() {
        return SpvcMslResourceBinding.ndesc_set(this.address());
    }

    @NativeType(value="unsigned int")
    public int binding() {
        return SpvcMslResourceBinding.nbinding(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_buffer() {
        return SpvcMslResourceBinding.nmsl_buffer(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_texture() {
        return SpvcMslResourceBinding.nmsl_texture(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_sampler() {
        return SpvcMslResourceBinding.nmsl_sampler(this.address());
    }

    public SpvcMslResourceBinding stage(@NativeType(value="SpvExecutionModel") int value) {
        SpvcMslResourceBinding.nstage(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding desc_set(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding.ndesc_set(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding binding(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding.nbinding(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding msl_buffer(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding.nmsl_buffer(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding msl_texture(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding.nmsl_texture(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding msl_sampler(@NativeType(value="unsigned int") int value) {
        SpvcMslResourceBinding.nmsl_sampler(this.address(), value);
        return this;
    }

    public SpvcMslResourceBinding set(int stage, int desc_set, int binding, int msl_buffer, int msl_texture, int msl_sampler) {
        this.stage(stage);
        this.desc_set(desc_set);
        this.binding(binding);
        this.msl_buffer(msl_buffer);
        this.msl_texture(msl_texture);
        this.msl_sampler(msl_sampler);
        return this;
    }

    public SpvcMslResourceBinding set(SpvcMslResourceBinding src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static SpvcMslResourceBinding malloc() {
        return (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static SpvcMslResourceBinding calloc() {
        return (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static SpvcMslResourceBinding create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static SpvcMslResourceBinding create(long address) {
        return (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)address);
    }

    @Nullable
    public static SpvcMslResourceBinding createSafe(long address) {
        return address == 0L ? null : (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)SpvcMslResourceBinding.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslResourceBinding.__create((int)capacity, (int)SIZEOF);
        return (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static SpvcMslResourceBinding malloc(MemoryStack stack) {
        return (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcMslResourceBinding calloc(MemoryStack stack) {
        return (SpvcMslResourceBinding)SpvcMslResourceBinding.wrap(SpvcMslResourceBinding.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)SpvcMslResourceBinding.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nstage(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGE);
    }

    public static int ndesc_set(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESC_SET);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int nmsl_buffer(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSL_BUFFER);
    }

    public static int nmsl_texture(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSL_TEXTURE);
    }

    public static int nmsl_sampler(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSL_SAMPLER);
    }

    public static void nstage(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGE, value);
    }

    public static void ndesc_set(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESC_SET, value);
    }

    public static void nbinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDING, value);
    }

    public static void nmsl_buffer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSL_BUFFER, value);
    }

    public static void nmsl_texture(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSL_TEXTURE, value);
    }

    public static void nmsl_sampler(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSL_SAMPLER, value);
    }

    static {
        Struct.Layout layout = SpvcMslResourceBinding.__struct((Struct.Member[])new Struct.Member[]{SpvcMslResourceBinding.__member((int)4), SpvcMslResourceBinding.__member((int)4), SpvcMslResourceBinding.__member((int)4), SpvcMslResourceBinding.__member((int)4), SpvcMslResourceBinding.__member((int)4), SpvcMslResourceBinding.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGE = layout.offsetof(0);
        DESC_SET = layout.offsetof(1);
        BINDING = layout.offsetof(2);
        MSL_BUFFER = layout.offsetof(3);
        MSL_TEXTURE = layout.offsetof(4);
        MSL_SAMPLER = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslResourceBinding, Buffer>
    implements NativeResource {
        private static final SpvcMslResourceBinding ELEMENT_FACTORY = SpvcMslResourceBinding.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected SpvcMslResourceBinding getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvExecutionModel")
        public int stage() {
            return SpvcMslResourceBinding.nstage(this.address());
        }

        @NativeType(value="unsigned int")
        public int desc_set() {
            return SpvcMslResourceBinding.ndesc_set(this.address());
        }

        @NativeType(value="unsigned int")
        public int binding() {
            return SpvcMslResourceBinding.nbinding(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_buffer() {
            return SpvcMslResourceBinding.nmsl_buffer(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_texture() {
            return SpvcMslResourceBinding.nmsl_texture(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_sampler() {
            return SpvcMslResourceBinding.nmsl_sampler(this.address());
        }

        public Buffer stage(@NativeType(value="SpvExecutionModel") int value) {
            SpvcMslResourceBinding.nstage(this.address(), value);
            return this;
        }

        public Buffer desc_set(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding.ndesc_set(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding.nbinding(this.address(), value);
            return this;
        }

        public Buffer msl_buffer(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding.nmsl_buffer(this.address(), value);
            return this;
        }

        public Buffer msl_texture(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding.nmsl_texture(this.address(), value);
            return this;
        }

        public Buffer msl_sampler(@NativeType(value="unsigned int") int value) {
            SpvcMslResourceBinding.nmsl_sampler(this.address(), value);
            return this;
        }
    }
}

