/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceConstructor
extends SimpleNodeConstructor {
    private Expression name;

    public NamespaceConstructor(Expression name) {
        this.name = name;
        this.adoptChildExpression(name);
    }

    public Expression getNameExpression() {
        return this.name;
    }

    @Override
    public int getInstructionNameCode() {
        return 175;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.NAMESPACE;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this.select, offer);
        this.name = this.doPromotion(this.name, offer);
        super.promoteInst(offer);
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        StaticContext env = visitor.getStaticContext();
        this.name = visitor.typeCheck(this.name, contextItemType);
        this.adoptChildExpression(this.name);
        RoleLocator role = new RoleLocator(4, "namespace/name", 0);
        this.name = TypeChecker.staticTypeCheck(this.name, SequenceType.OPTIONAL_ATOMIC, false, role, visitor);
        this.adoptChildExpression(this.name);
        if (this.name instanceof Literal) {
            this.evaluatePrefix(env.makeEarlyEvaluationContext());
        }
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(new Operand(this.name, OperandRole.SINGLE_ATOMIC), new Operand(this.select, OperandRole.SINGLE_ATOMIC));
    }

    @Override
    public Expression copy() {
        NamespaceConstructor exp = new NamespaceConstructor(this.name.copy());
        exp.setSelect(this.select.copy(), this.getContainer().getConfiguration());
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.name == original) {
            this.name = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public NodeName evaluateNodeName(XPathContext context) throws XPathException {
        String prefix = this.evaluatePrefix(context);
        return new NoNamespaceName(prefix);
    }

    private String evaluatePrefix(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.name.evaluateItem(context);
        if (value == null) {
            return "";
        }
        if (!(value instanceof StringValue) || value instanceof AnyURIValue) {
            XPathException err = new XPathException("Namespace prefix is not an xs:string or xs:untypedAtomic", this);
            err.setErrorCode("XPTY0004");
            err.setXPathContext(context);
            err.setIsTypeError(true);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        String prefix = Whitespace.trim(value.getStringValueCS());
        if (prefix.length() != 0 && !NameChecker.isValidNCName(prefix)) {
            XPathException err = new XPathException("Namespace prefix is invalid: " + prefix, this);
            err.setErrorCode(this.isXSLT() ? "XTDE0920" : "FORG0001");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (prefix.equals("xmlns")) {
            XPathException err = new XPathException("Namespace prefix 'xmlns' is not allowed", this);
            err.setErrorCode(this.isXSLT() ? "XTDE0920" : "XQDY0101");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        return prefix;
    }

    @Override
    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        String prefix = this.evaluatePrefix(context);
        String uri = value.toString();
        this.checkPrefixAndUri(prefix, uri, context);
        NamespaceBinding nscode = new NamespaceBinding(prefix, uri);
        SequenceReceiver out = context.getReceiver();
        out.namespace(nscode, 32);
    }

    @Override
    public NodeInfo evaluateItem(XPathContext context) throws XPathException {
        NodeInfo node = (NodeInfo)super.evaluateItem(context);
        assert (node != null);
        String prefix = node.getLocalPart();
        String uri = node.getStringValue();
        this.checkPrefixAndUri(prefix, uri, context);
        return node;
    }

    private void checkPrefixAndUri(String prefix, String uri, XPathContext context) throws XPathException {
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            XPathException err = new XPathException("Namespace prefix 'xml' and namespace uri http://www.w3.org/XML/1998/namespace must only be used together", this);
            err.setErrorCode(this.isXSLT() ? "XTDE0925" : "XQDY0101");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (uri.length() == 0) {
            XPathException err = new XPathException("Namespace URI is an empty string", this);
            err.setErrorCode(this.isXSLT() ? "XTDE0930" : "XQDY0101");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            XPathException err = new XPathException("A namespace node cannot have the reserved namespace http://www.w3.org/2000/xmlns/", this);
            err.setErrorCode("XTDE0935");
            err.setXPathContext(context);
            throw NamespaceConstructor.dynamicError(this, err, context);
        }
        if (!StandardURIChecker.getInstance().isValidURI(uri)) {
            XPathException de = new XPathException("The string value of the constructed namespace node must be a valid URI");
            de.setErrorCode("XTDE0905");
            de.setXPathContext(context);
            de.setLocator(this);
            throw de;
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("namespace");
        out.startSubsidiaryElement("name");
        this.name.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("select");
        this.getContentExpression().explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

