/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.reference;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.derby.shared.api.DerbyModuleAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.info.JVMInfo;

public class ModuleUtil {
    public static final String ENGINE_MODULE_NAME = "org.apache.derby.engine";
    public static final String CLIENT_MODULE_NAME = "org.apache.derby.client";
    public static final String SERVER_MODULE_NAME = "org.apache.derby.server";
    public static final String RUNNER_MODULE_NAME = "org.apache.derby.runner";
    public static final String SHARED_MODULE_NAME = "org.apache.derby.commons";
    public static final String TOOLS_MODULE_NAME = "org.apache.derby.tools";
    public static final String OPTIONALTOOLS_MODULE_NAME = "org.apache.derby.optionaltools";
    public static final String TESTING_MODULE_NAME = "org.apache.derby.tests";
    public static final String LOCALE_MODULE_NAME_PREFIX = "org.apache.derby.locale_";
    private static HashMap<String, Module> _derbyModules;

    public static Module derbyModule(String moduleName) {
        if (!JVMInfo.isModuleAware()) {
            return null;
        }
        ModuleUtil.initModuleInfo();
        return _derbyModules.get(moduleName);
    }

    public static String localizationModuleName(String localeString) {
        return LOCALE_MODULE_NAME_PREFIX + localeString;
    }

    public static InputStream getResourceAsStream(String resourceName) throws StandardException {
        Module module;
        ModuleUtil.initModuleInfo();
        InputStream retval = null;
        Iterator<Module> iterator = _derbyModules.values().iterator();
        while (iterator.hasNext() && (retval = ModuleUtil.getResourceAsStream(module = iterator.next(), resourceName)) == null) {
        }
        return retval;
    }

    private static void initModuleInfo() {
        if (_derbyModules != null) {
            return;
        }
        HashMap<String, Module> result = new HashMap<String, Module>();
        ServiceLoader<DerbyModuleAPI> loader = ServiceLoader.load(DerbyModuleAPI.class);
        for (DerbyModuleAPI provider : loader) {
            Class<?> providerClass = provider.getClass();
            Module providerModule = providerClass.getModule();
            result.put(providerModule.getName(), providerModule);
        }
        _derbyModules = result;
    }

    private static InputStream getResourceAsStream(final Module module, final String resourceName) throws StandardException {
        InputStream retval = null;
        PrivilegedActionException error = null;
        try {
            retval = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return module.getResourceAsStream(resourceName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            error = pae;
        }
        if (error != null) {
            throw StandardException.plainWrapException(error);
        }
        return retval;
    }
}

