/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.List;
import org.hibernate.models.internal.AttributeDescriptorImpl;
import org.hibernate.models.internal.jdk.JdkArrayValueConverter;
import org.hibernate.models.internal.jdk.JdkArrayValueExtractor;
import org.hibernate.models.internal.jdk.JdkPassThruConverter;
import org.hibernate.models.internal.jdk.JdkPassThruExtractor;
import org.hibernate.models.rendering.spi.Renderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.JdkValueConverter;
import org.hibernate.models.spi.JdkValueExtractor;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.ValueTypeDescriptor;

public class ArrayTypeDescriptor<V>
implements ValueTypeDescriptor<V[]> {
    private final ValueTypeDescriptor<V> elementTypeDescriptor;
    private final Class<V> componentType;
    private final Class<V[]> arrayType;
    private JdkValueConverter<V[]> jdkValueConverter;
    private JdkValueExtractor<V[]> jdkValueExtractor;

    public ArrayTypeDescriptor(ValueTypeDescriptor<V> elementTypeDescriptor) {
        this.elementTypeDescriptor = elementTypeDescriptor;
        this.componentType = elementTypeDescriptor.getValueType();
        this.arrayType = this.componentType.arrayType();
    }

    public ValueTypeDescriptor<V> getElementTypeDescriptor() {
        return this.elementTypeDescriptor;
    }

    @Override
    public Class<V[]> getValueType() {
        return this.arrayType;
    }

    @Override
    public AttributeDescriptor<V[]> createAttributeDescriptor(Class<? extends Annotation> annotationType, String attributeName) {
        return new AttributeDescriptorImpl<V[]>(annotationType, attributeName, this);
    }

    @Override
    public JdkValueConverter<V[]> createJdkValueConverter(ModelsContext modelContext) {
        if (this.jdkValueConverter == null) {
            this.jdkValueConverter = !this.elementTypeDescriptor.getValueType().isAnnotation() ? JdkPassThruConverter.passThruConverter() : new JdkArrayValueConverter<V>(this.elementTypeDescriptor);
        }
        return this.jdkValueConverter;
    }

    @Override
    public JdkValueExtractor<V[]> createJdkValueExtractor(ModelsContext modelContext) {
        if (this.jdkValueExtractor == null) {
            this.jdkValueExtractor = !this.elementTypeDescriptor.getValueType().isAnnotation() ? JdkPassThruExtractor.passThruExtractor() : new JdkArrayValueExtractor(this.createJdkValueConverter(modelContext));
        }
        return this.jdkValueExtractor;
    }

    @Override
    public Object unwrap(V[] value) {
        Object[] result = (Object[])Array.newInstance(this.componentType, value.length);
        for (int i = 0; i < value.length; ++i) {
            result[i] = this.elementTypeDescriptor.unwrap(value[i]);
        }
        return result;
    }

    @Override
    public void render(String name, Object attributeValue, RenderingTarget target, Renderer renderer, ModelsContext modelContext) {
        assert (attributeValue != null) : "Annotation value was null - " + name;
        Object[] values = (Object[])attributeValue;
        target.addLine("%s = {", name);
        target.indent(2);
        for (Object value : values) {
            this.elementTypeDescriptor.render(value, target, renderer, modelContext);
        }
        target.unindent(2);
        target.addLine("}");
    }

    @Override
    public void render(Object attributeValue, RenderingTarget target, Renderer renderer, ModelsContext modelContext) {
        List values = (List)attributeValue;
        target.addLine("{");
        target.indent(2);
        values.forEach(value -> this.elementTypeDescriptor.render(value, target, renderer, modelContext));
        target.unindent(2);
        target.addLine("}");
    }

    public V[][] makeArray(int size, ModelsContext modelContext) {
        throw new UnsupportedOperationException("Nested array creation not supported");
    }
}

