/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.community.dialect.AltibaseDialect;
import org.hibernate.community.dialect.CUBRIDDialect;
import org.hibernate.community.dialect.CacheDialect;
import org.hibernate.community.dialect.DerbyDialect;
import org.hibernate.community.dialect.FirebirdDialect;
import org.hibernate.community.dialect.GaussDBDialect;
import org.hibernate.community.dialect.InformixDialect;
import org.hibernate.community.dialect.IngresDialect;
import org.hibernate.community.dialect.MaxDBDialect;
import org.hibernate.community.dialect.MimerSQLDialect;
import org.hibernate.community.dialect.SQLiteDialect;
import org.hibernate.community.dialect.SingleStoreDialect;
import org.hibernate.community.dialect.SybaseAnywhereDialect;
import org.hibernate.community.dialect.TeradataDialect;
import org.hibernate.community.dialect.TimesTenDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CommunityDatabase {
    SQLITE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new SQLiteDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("SQLite");
        }
    }
    ,
    INGRES{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new IngresDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.toLowerCase().startsWith("ingres");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.ingres.jdbc.IngresDriver";
        }
    }
    ,
    INFORMIX{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new InformixDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.toLowerCase().startsWith("informix");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.informix.jdbc.IfxDriver";
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:informix-";
        }
    }
    ,
    FIREBIRD{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new FirebirdDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("Firebird");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "org.firebirdsql.jdbc.FBDriver";
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:firebird";
        }
    }
    ,
    CACHE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new CacheDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("Cache");
        }
    }
    ,
    CUBRID{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new CUBRIDDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "CUBRID".equalsIgnoreCase(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "cubrid.jdbc.driver.CUBRIDDriver";
        }
    }
    ,
    ALTIBASE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new AltibaseDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "Altibase".equalsIgnoreCase(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "Altibase.jdbc.driver.AltibaseDriver";
        }
    }
    ,
    MIMER{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new MimerSQLDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.startsWith("Mimer SQL");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.mimer.jdbc.Driver";
        }
    }
    ,
    MAXDB{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new MaxDBDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.toLowerCase().startsWith("sap db") || databaseName.toLowerCase().startsWith("maxdb");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:sapdb:";
        }
    }
    ,
    SYBASE_ANYWHERE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            String databaseName = info.getDatabaseName();
            if (this.isASA(databaseName)) {
                return new SybaseAnywhereDialect(info);
            }
            return null;
        }

        private boolean isASA(String databaseName) {
            return databaseName.startsWith("Adaptive Server Anywhere") || "SQL Anywhere".equals(databaseName);
        }

        @Override
        public boolean productNameMatches(String productName) {
            return this.isASA(productName);
        }

        @Override
        public boolean matchesUrl(String jdbcUrl) {
            return jdbcUrl.startsWith("jdbc:sybase:") || jdbcUrl.startsWith("jdbc:sqlanywhere:");
        }
    }
    ,
    TERADATA{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new TeradataDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "Teradata".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.teradata.jdbc.TeraDriver";
        }
    }
    ,
    TIMESTEN{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new TimesTenDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.toLowerCase().startsWith("timesten");
        }
    }
    ,
    SINGLESTORE{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new SingleStoreDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return databaseName.toLowerCase().startsWith("singlestore");
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.singlestore.jdbc.Driver";
        }
    }
    ,
    DERBY{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new DerbyDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "Apache Derby".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return jdbcUrl.startsWith("jdbc:derby://") ? "org.apache.derby.jdbc.ClientDriver" : "org.apache.derby.jdbc.EmbeddedDriver";
        }
    }
    ,
    GAUSSDB{

        @Override
        public Dialect createDialect(DialectResolutionInfo info) {
            return new GaussDBDialect(info);
        }

        @Override
        public boolean productNameMatches(String databaseName) {
            return "GaussDB".equals(databaseName);
        }

        @Override
        public String getDriverClassName(String jdbcUrl) {
            return "com.huawei.gaussdb.jdbc.Driver";
        }
    };


    public boolean matchesResolutionInfo(DialectResolutionInfo info) {
        return this.productNameMatches(info.getDatabaseName());
    }

    public abstract boolean productNameMatches(String var1);

    public abstract Dialect createDialect(DialectResolutionInfo var1);

    public String getDriverClassName(String jdbcUrl) {
        return null;
    }

    public String getUrlPrefix() {
        return "jdbc:" + this.toString().toLowerCase() + ":";
    }

    public boolean matchesUrl(String jdbcUrl) {
        return jdbcUrl.toLowerCase().startsWith(this.getUrlPrefix());
    }
}

