/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import java.util.stream.AbstractPipeline;
import java.util.stream.ForEachOps;
import java.util.stream.Node;
import java.util.stream.Nodes;
import java.util.stream.PipelineHelper;
import java.util.stream.ReduceOps;
import java.util.stream.ReferencePipeline;
import java.util.stream.Sink;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.StreamSpliterators;
import java.util.stream.TerminalOp;

final class DistinctOps {
    private DistinctOps() {
    }

    static <T> ReferencePipeline<T, T> makeRef(AbstractPipeline<?, T, ?> abstractPipeline) {
        return new ReferencePipeline.StatefulOp<T, T>(abstractPipeline, StreamShape.REFERENCE, StreamOpFlag.IS_DISTINCT | StreamOpFlag.NOT_SIZED){

            @Override
            <P_IN> Node<T> reduce(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
                TerminalOp<Object, LinkedHashSet> terminalOp = ReduceOps.makeRef(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
                return Nodes.node(terminalOp.evaluateParallel(pipelineHelper, spliterator));
            }

            @Override
            <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<T[]> intFunction) {
                if (StreamOpFlag.DISTINCT.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return pipelineHelper.evaluate(spliterator, false, intFunction);
                }
                if (StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return this.reduce(pipelineHelper, spliterator);
                }
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                TerminalOp<Object, Void> terminalOp = ForEachOps.makeRef(object -> {
                    if (object == null) {
                        atomicBoolean.set(true);
                    } else {
                        concurrentHashMap.putIfAbsent(object, Boolean.TRUE);
                    }
                }, false);
                terminalOp.evaluateParallel(pipelineHelper, spliterator);
                HashSet<Object> hashSet = concurrentHashMap.keySet();
                if (atomicBoolean.get()) {
                    hashSet = new HashSet<Object>(hashSet);
                    hashSet.add(null);
                }
                return Nodes.node(hashSet);
            }

            @Override
            <P_IN> Spliterator<T> opEvaluateParallelLazy(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
                if (StreamOpFlag.DISTINCT.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return pipelineHelper.wrapSpliterator(spliterator);
                }
                if (StreamOpFlag.ORDERED.isKnown(pipelineHelper.getStreamAndOpFlags())) {
                    return this.reduce(pipelineHelper, spliterator).spliterator();
                }
                return new StreamSpliterators.DistinctSpliterator(pipelineHelper.wrapSpliterator(spliterator));
            }

            @Override
            Sink<T> opWrapSink(int n, Sink<T> sink) {
                Objects.requireNonNull(sink);
                if (StreamOpFlag.DISTINCT.isKnown(n)) {
                    return sink;
                }
                if (StreamOpFlag.SORTED.isKnown(n)) {
                    return new Sink.ChainedReference<T, T>(sink){
                        boolean seenNull;
                        T lastSeen;

                        @Override
                        public void begin(long l) {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.begin(-1L);
                        }

                        @Override
                        public void end() {
                            this.seenNull = false;
                            this.lastSeen = null;
                            this.downstream.end();
                        }

                        @Override
                        public void accept(T t) {
                            if (t == null) {
                                if (!this.seenNull) {
                                    this.seenNull = true;
                                    this.lastSeen = null;
                                    this.downstream.accept(null);
                                }
                            } else if (this.lastSeen == null || !t.equals(this.lastSeen)) {
                                this.lastSeen = t;
                                this.downstream.accept(this.lastSeen);
                            }
                        }
                    };
                }
                return new Sink.ChainedReference<T, T>(sink){
                    Set<T> seen;

                    @Override
                    public void begin(long l) {
                        this.seen = new HashSet();
                        this.downstream.begin(-1L);
                    }

                    @Override
                    public void end() {
                        this.seen = null;
                        this.downstream.end();
                    }

                    @Override
                    public void accept(T t) {
                        if (!this.seen.contains(t)) {
                            this.seen.add(t);
                            this.downstream.accept(t);
                        }
                    }
                };
            }
        };
    }
}

