/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.CharTrie;
import sun.text.normalizer.ICUBinary;
import sun.text.normalizer.ICUData;

public final class UBiDiProps {
    private static UBiDiProps gBdp = null;
    private static UBiDiProps gBdpDummy = null;
    private int[] indexes;
    private int[] mirrors;
    private byte[] jgArray;
    private CharTrie trie;
    private static final String DATA_FILE_NAME = "/sun/text/resources/ubidi.icu";
    private static final byte[] FMT = new byte[]{66, 105, 68, 105};
    private static final int IX_INDEX_TOP = 0;
    private static final int IX_MIRROR_LENGTH = 3;
    private static final int IX_JG_START = 4;
    private static final int IX_JG_LIMIT = 5;
    private static final int IX_TOP = 16;
    private static final int CLASS_MASK = 31;

    public UBiDiProps() throws IOException {
        InputStream inputStream = ICUData.getStream(DATA_FILE_NAME);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        this.readData(bufferedInputStream);
        bufferedInputStream.close();
        inputStream.close();
    }

    private void readData(InputStream inputStream) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ICUBinary.readHeader(dataInputStream, FMT, new IsAcceptable());
        int n2 = dataInputStream.readInt();
        if (n2 < 0) {
            throw new IOException("indexes[0] too small in /sun/text/resources/ubidi.icu");
        }
        this.indexes = new int[n2];
        this.indexes[0] = n2;
        for (n = 1; n < n2; ++n) {
            this.indexes[n] = dataInputStream.readInt();
        }
        this.trie = new CharTrie(dataInputStream, null);
        n2 = this.indexes[3];
        if (n2 > 0) {
            this.mirrors = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.mirrors[n] = dataInputStream.readInt();
            }
        }
        n2 = this.indexes[5] - this.indexes[4];
        this.jgArray = new byte[n2];
        for (n = 0; n < n2; ++n) {
            this.jgArray[n] = dataInputStream.readByte();
        }
    }

    public static final synchronized UBiDiProps getSingleton() throws IOException {
        if (gBdp == null) {
            gBdp = new UBiDiProps();
        }
        return gBdp;
    }

    private UBiDiProps(boolean bl) {
        this.indexes = new int[16];
        this.indexes[0] = 16;
        this.trie = new CharTrie(0, 0, null);
    }

    public static final synchronized UBiDiProps getDummy() {
        if (gBdpDummy == null) {
            gBdpDummy = new UBiDiProps(true);
        }
        return gBdpDummy;
    }

    public final int getClass(int n) {
        return UBiDiProps.getClassFromProps(this.trie.getCodePointValue(n));
    }

    private static final int getClassFromProps(int n) {
        return n & 0x1F;
    }

    private final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 1 && byArray[2] == 5 && byArray[3] == 2;
        }
    }
}

