/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    final Object[] items;
    int takeIndex;
    int putIndex;
    int count;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    transient Itrs itrs = null;

    final int dec(int n) {
        return (n == 0 ? this.items.length : n) - 1;
    }

    final E itemAt(int n) {
        return (E)this.items[n];
    }

    private static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    private void enqueue(E e) {
        Object[] objectArray = this.items;
        objectArray[this.putIndex] = e;
        if (++this.putIndex == objectArray.length) {
            this.putIndex = 0;
        }
        ++this.count;
        this.notEmpty.signal();
    }

    private E dequeue() {
        Object[] objectArray = this.items;
        Object object = objectArray[this.takeIndex];
        objectArray[this.takeIndex] = null;
        if (++this.takeIndex == objectArray.length) {
            this.takeIndex = 0;
        }
        --this.count;
        if (this.itrs != null) {
            this.itrs.elementDequeued();
        }
        this.notFull.signal();
        return (E)object;
    }

    void removeAt(int n) {
        Object[] objectArray = this.items;
        if (n == this.takeIndex) {
            objectArray[this.takeIndex] = null;
            if (++this.takeIndex == objectArray.length) {
                this.takeIndex = 0;
            }
            --this.count;
            if (this.itrs != null) {
                this.itrs.elementDequeued();
            }
        } else {
            int n2 = this.putIndex;
            int n3 = n;
            while (true) {
                int n4;
                if ((n4 = n3 + 1) == objectArray.length) {
                    n4 = 0;
                }
                if (n4 == n2) break;
                objectArray[n3] = objectArray[n4];
                n3 = n4;
            }
            objectArray[n3] = null;
            this.putIndex = n3;
            --this.count;
            if (this.itrs != null) {
                this.itrs.removedAt(n);
            }
        }
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int n) {
        this(n, false);
    }

    public ArrayBlockingQueue(int n, boolean bl) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[n];
        this.lock = new ReentrantLock(bl);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayBlockingQueue(int n, boolean bl, Collection<? extends E> collection) {
        this(n, bl);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2 = 0;
            try {
                for (E e : collection) {
                    ArrayBlockingQueue.checkNotNull(e);
                    this.items[n2++] = e;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException();
            }
            this.count = n2;
            this.putIndex = n2 == n ? 0 : n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl = false;
                return bl;
            }
            this.enqueue(e);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.enqueue(e);
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.notFull.awaitNanos(l2);
            }
            this.enqueue(e);
            boolean bl = true;
            return bl;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E poll() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.dequeue();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            E e = this.dequeue();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        try {
            while (this.count == 0) {
                if (l2 <= 0L) {
                    E e = null;
                    return e;
                }
                l2 = this.notEmpty.awaitNanos(l2);
            }
            E e = this.dequeue();
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            E e = this.itemAt(this.takeIndex);
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            if (this.count > 0) {
                n = this.putIndex;
                int n2 = this.takeIndex;
                do {
                    if (object.equals(objectArray[n2])) {
                        this.removeAt(n2);
                        boolean bl = true;
                        return bl;
                    }
                    if (++n2 != objectArray.length) continue;
                    n2 = 0;
                } while (n2 != n);
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            if (this.count > 0) {
                n = this.putIndex;
                int n2 = this.takeIndex;
                do {
                    if (object.equals(objectArray[n2])) {
                        boolean bl = true;
                        return bl;
                    }
                    if (++n2 != objectArray.length) continue;
                    n2 = 0;
                } while (n2 != n);
            }
            n = 0;
            return n != 0;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] objectArray;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            objectArray = new Object[n];
            int n2 = this.items.length - this.takeIndex;
            if (n <= n2) {
                System.arraycopy(this.items, this.takeIndex, objectArray, 0, n);
            } else {
                System.arraycopy(this.items, this.takeIndex, objectArray, 0, n2);
                System.arraycopy(this.items, 0, objectArray, n2, n - n2);
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        Object[] objectArray2 = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n;
            int n2 = this.count;
            int n3 = objectArray.length;
            if (n3 < n2) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
            }
            if (n2 <= (n = objectArray2.length - this.takeIndex)) {
                System.arraycopy(objectArray2, this.takeIndex, objectArray, 0, n2);
            } else {
                System.arraycopy(objectArray2, this.takeIndex, objectArray, 0, n);
                System.arraycopy(objectArray2, 0, objectArray, n, n2 - n);
            }
            if (n3 > n2) {
                objectArray[n2] = null;
            }
        }
        finally {
            reentrantLock.unlock();
        }
        return objectArray;
    }

    @Override
    public String toString() {
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            if (n == 0) {
                String string = "[]";
                return string;
            }
            Object[] objectArray = this.items;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            int n2 = this.takeIndex;
            while (true) {
                Object object;
                stringBuilder.append((object = objectArray[n2]) == this ? "(this Collection)" : object);
                if (--n == 0) {
                    String string = stringBuilder.append(']').toString();
                    return string;
                }
                stringBuilder.append(',').append(' ');
                if (++n2 != objectArray.length) continue;
                n2 = 0;
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n = this.count;
            if (n > 0) {
                int n2 = this.putIndex;
                int n3 = this.takeIndex;
                do {
                    objectArray[n3] = null;
                    if (++n3 != objectArray.length) continue;
                    n3 = 0;
                } while (n3 != n2);
                this.takeIndex = n2;
                this.count = 0;
                if (this.itrs != null) {
                    this.itrs.queueIsEmpty();
                }
                while (n > 0 && reentrantLock.hasWaiters(this.notFull)) {
                    this.notFull.signal();
                    --n;
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        ArrayBlockingQueue.checkNotNull(collection);
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        if (n <= 0) {
            return 0;
        }
        Object[] objectArray = this.items;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        try {
            int n2;
            block17: {
                int n3;
                block18: {
                    int n4 = Math.min(n, this.count);
                    int n5 = this.takeIndex;
                    try {
                        for (n3 = 0; n3 < n4; ++n3) {
                            Object object = objectArray[n5];
                            collection.add(object);
                            objectArray[n5] = null;
                            if (++n5 != objectArray.length) continue;
                            n5 = 0;
                        }
                        n2 = n4;
                        if (n3 <= 0) break block17;
                        this.count -= n3;
                        this.takeIndex = n5;
                        if (this.itrs == null) break block18;
                        if (this.count == 0) {
                            this.itrs.queueIsEmpty();
                            break block18;
                        }
                        if (n3 <= n5) break block18;
                        this.itrs.takeIndexWrapped();
                    }
                    catch (Throwable throwable) {
                        if (n3 > 0) {
                            this.count -= n3;
                            this.takeIndex = n5;
                            if (this.itrs != null) {
                                if (this.count == 0) {
                                    this.itrs.queueIsEmpty();
                                } else if (n3 > n5) {
                                    this.itrs.takeIndexWrapped();
                                }
                            }
                            while (n3 > 0 && reentrantLock.hasWaiters(this.notFull)) {
                                this.notFull.signal();
                                --n3;
                            }
                        }
                        throw throwable;
                    }
                }
                while (n3 > 0 && reentrantLock.hasWaiters(this.notFull)) {
                    this.notFull.signal();
                    --n3;
                }
            }
            return n2;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 4368);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.items.length == 0 || this.takeIndex < 0 || this.takeIndex >= this.items.length || this.putIndex < 0 || this.putIndex >= this.items.length || this.count < 0 || this.count > this.items.length || Math.floorMod(this.putIndex - this.takeIndex, this.items.length) != Math.floorMod(this.count, this.items.length)) {
            throw new InvalidObjectException("invariants violated");
        }
    }

    private class Itr
    implements Iterator<E> {
        private int cursor;
        private E nextItem;
        private int nextIndex;
        private E lastItem;
        private int lastRet = -1;
        private int prevTakeIndex;
        private int prevCycles;
        private static final int NONE = -1;
        private static final int REMOVED = -2;
        private static final int DETACHED = -3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (ArrayBlockingQueue.this.count == 0) {
                    this.cursor = -1;
                    this.nextIndex = -1;
                    this.prevTakeIndex = -3;
                } else {
                    int n;
                    this.prevTakeIndex = n = ArrayBlockingQueue.this.takeIndex;
                    this.nextIndex = n;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    this.cursor = this.incCursor(n);
                    if (ArrayBlockingQueue.this.itrs == null) {
                        ArrayBlockingQueue.this.itrs = new Itrs(this);
                    } else {
                        ArrayBlockingQueue.this.itrs.register(this);
                        ArrayBlockingQueue.this.itrs.doSomeSweeping(false);
                    }
                    this.prevCycles = ArrayBlockingQueue.this.itrs.cycles;
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }

        boolean isDetached() {
            return this.prevTakeIndex < 0;
        }

        private int incCursor(int n) {
            if (++n == ArrayBlockingQueue.this.items.length) {
                n = 0;
            }
            if (n == ArrayBlockingQueue.this.putIndex) {
                n = -1;
            }
            return n;
        }

        private boolean invalidated(int n, int n2, long l, int n3) {
            if (n < 0) {
                return false;
            }
            int n4 = n - n2;
            if (n4 < 0) {
                n4 += n3;
            }
            return l > (long)n4;
        }

        private void incorporateDequeues() {
            int n = ArrayBlockingQueue.this.itrs.cycles;
            int n2 = ArrayBlockingQueue.this.takeIndex;
            int n3 = this.prevCycles;
            int n4 = this.prevTakeIndex;
            if (n != n3 || n2 != n4) {
                int n5 = ArrayBlockingQueue.this.items.length;
                long l = (n - n3) * n5 + (n2 - n4);
                if (this.invalidated(this.lastRet, n4, l, n5)) {
                    this.lastRet = -2;
                }
                if (this.invalidated(this.nextIndex, n4, l, n5)) {
                    this.nextIndex = -2;
                }
                if (this.invalidated(this.cursor, n4, l, n5)) {
                    this.cursor = n2;
                }
                if (this.cursor < 0 && this.nextIndex < 0 && this.lastRet < 0) {
                    this.detach();
                } else {
                    this.prevCycles = n;
                    this.prevTakeIndex = n2;
                }
            }
        }

        private void detach() {
            if (this.prevTakeIndex >= 0) {
                this.prevTakeIndex = -3;
                ArrayBlockingQueue.this.itrs.doSomeSweeping(true);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextItem != null) {
                return true;
            }
            this.noNext();
            return false;
        }

        private void noNext() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                    if (this.lastRet >= 0) {
                        this.lastItem = ArrayBlockingQueue.this.itemAt(this.lastRet);
                        this.detach();
                    }
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object e = this.nextItem;
            if (e == null) {
                throw new NoSuchElementException();
            }
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                this.lastRet = this.nextIndex;
                int n = this.cursor;
                if (n >= 0) {
                    this.nextIndex = n;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    this.cursor = this.incCursor(n);
                } else {
                    this.nextIndex = -1;
                    this.nextItem = null;
                }
            }
            finally {
                reentrantLock.unlock();
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock reentrantLock = ArrayBlockingQueue.this.lock;
            reentrantLock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                int n = this.lastRet;
                this.lastRet = -1;
                if (n >= 0) {
                    if (!this.isDetached()) {
                        ArrayBlockingQueue.this.removeAt(n);
                    } else {
                        Object e = this.lastItem;
                        this.lastItem = null;
                        if (ArrayBlockingQueue.this.itemAt(n) == e) {
                            ArrayBlockingQueue.this.removeAt(n);
                        }
                    }
                } else if (n == -1) {
                    throw new IllegalStateException();
                }
                if (this.cursor < 0 && this.nextIndex < 0) {
                    this.detach();
                }
            }
            finally {
                reentrantLock.unlock();
            }
        }

        void shutdown() {
            this.cursor = -1;
            if (this.nextIndex >= 0) {
                this.nextIndex = -2;
            }
            if (this.lastRet >= 0) {
                this.lastRet = -2;
                this.lastItem = null;
            }
            this.prevTakeIndex = -3;
        }

        private int distance(int n, int n2, int n3) {
            int n4 = n - n2;
            if (n4 < 0) {
                n4 += n3;
            }
            return n4;
        }

        boolean removedAt(int n) {
            int n2;
            int n3;
            if (this.isDetached()) {
                return true;
            }
            int n4 = ArrayBlockingQueue.this.itrs.cycles;
            int n5 = ArrayBlockingQueue.this.takeIndex;
            int n6 = this.prevCycles;
            int n7 = this.prevTakeIndex;
            int n8 = ArrayBlockingQueue.this.items.length;
            int n9 = n4 - n6;
            if (n < n5) {
                ++n9;
            }
            int n10 = n9 * n8 + (n - n7);
            int n11 = this.cursor;
            if (n11 >= 0) {
                n3 = this.distance(n11, n7, n8);
                if (n3 == n10) {
                    if (n11 == ArrayBlockingQueue.this.putIndex) {
                        n11 = -1;
                        this.cursor = -1;
                    }
                } else if (n3 > n10) {
                    this.cursor = n11 = ArrayBlockingQueue.this.dec(n11);
                }
            }
            if ((n3 = this.lastRet) >= 0) {
                n2 = this.distance(n3, n7, n8);
                if (n2 == n10) {
                    n3 = -2;
                    this.lastRet = -2;
                } else if (n2 > n10) {
                    this.lastRet = n3 = ArrayBlockingQueue.this.dec(n3);
                }
            }
            if ((n2 = this.nextIndex) >= 0) {
                int n12 = this.distance(n2, n7, n8);
                if (n12 == n10) {
                    n2 = -2;
                    this.nextIndex = -2;
                } else if (n12 > n10) {
                    this.nextIndex = n2 = ArrayBlockingQueue.this.dec(n2);
                }
            } else if (n11 < 0 && n2 < 0 && n3 < 0) {
                this.prevTakeIndex = -3;
                return true;
            }
            return false;
        }

        boolean takeIndexWrapped() {
            if (this.isDetached()) {
                return true;
            }
            if (ArrayBlockingQueue.this.itrs.cycles - this.prevCycles > 1) {
                this.shutdown();
                return true;
            }
            return false;
        }
    }

    class Itrs {
        int cycles = 0;
        private java.util.concurrent.ArrayBlockingQueue$Itrs.Node head;
        private java.util.concurrent.ArrayBlockingQueue$Itrs.Node sweeper = null;
        private static final int SHORT_SWEEP_PROBES = 4;
        private static final int LONG_SWEEP_PROBES = 16;

        Itrs(Itr itr) {
            this.register(itr);
        }

        void doSomeSweeping(boolean bl) {
            boolean bl2;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node2;
            int n = bl ? 16 : 4;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node3 = this.sweeper;
            if (node3 == null) {
                node2 = null;
                node = this.head;
                bl2 = true;
            } else {
                node2 = node3;
                node = node2.next;
                bl2 = false;
            }
            while (n > 0) {
                if (node == null) {
                    if (bl2) break;
                    node2 = null;
                    node = this.head;
                    bl2 = true;
                }
                Itr itr = (Itr)node.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node node4 = node.next;
                if (itr == null || itr.isDetached()) {
                    n = 16;
                    node.clear();
                    node.next = null;
                    if (node2 == null) {
                        this.head = node4;
                        if (node4 == null) {
                            ArrayBlockingQueue.this.itrs = null;
                            return;
                        }
                    } else {
                        node2.next = node4;
                    }
                } else {
                    node2 = node;
                }
                node = node4;
                --n;
            }
            this.sweeper = node == null ? null : node2;
        }

        void register(Itr itr) {
            this.head = new Node(this, itr, (Node)this.head);
        }

        void takeIndexWrapped() {
            ++this.cycles;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node = null;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node2 = this.head;
            while (node2 != null) {
                Itr itr = (Itr)node2.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node node3 = node2.next;
                if (itr == null || itr.takeIndexWrapped()) {
                    node2.clear();
                    node2.next = null;
                    if (node == null) {
                        this.head = node3;
                    } else {
                        node.next = node3;
                    }
                } else {
                    node = node2;
                }
                node2 = node3;
            }
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void removedAt(int n) {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node = null;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node2 = this.head;
            while (node2 != null) {
                Itr itr = (Itr)node2.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node node3 = node2.next;
                if (itr == null || itr.removedAt(n)) {
                    node2.clear();
                    node2.next = null;
                    if (node == null) {
                        this.head = node3;
                    } else {
                        node.next = node3;
                    }
                } else {
                    node = node2;
                }
                node2 = node3;
            }
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void queueIsEmpty() {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node node = this.head;
            while (node != null) {
                Itr itr = (Itr)node.get();
                if (itr != null) {
                    node.clear();
                    itr.shutdown();
                }
                node = node.next;
            }
            this.head = null;
            ArrayBlockingQueue.this.itrs = null;
        }

        void elementDequeued() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.queueIsEmpty();
            } else if (ArrayBlockingQueue.this.takeIndex == 0) {
                this.takeIndexWrapped();
            }
        }

        private static class Node
        extends WeakReference<Itr> {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node next;
            final /* synthetic */ Itrs this$1;

            Node(Itr itr, java.util.concurrent.ArrayBlockingQueue$Itrs.Node node) {
                this.this$1 = var1_1;
                super(itr);
                this.next = node;
            }
        }
    }
}

