/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.Objects;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.Twine24;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class StringView
extends UnicodeString {
    private final String baseString;
    private UnicodeString baseUnicodeString;

    private StringView(String baseString) {
        Objects.requireNonNull(baseString);
        this.baseString = baseString;
    }

    public static UnicodeString of(String base) {
        return new StringView(base);
    }

    public static UnicodeString wrap(String base) {
        return new StringView(base).tidy();
    }

    public static UnicodeString tidy(String base) {
        return new StringView(base).tidy();
    }

    @Override
    public synchronized UnicodeString tidy() {
        if (this.baseUnicodeString != null) {
            return this.baseUnicodeString;
        }
        int uLength = StringTool.getStringLength(this.baseString);
        if (uLength == this.baseString.length()) {
            this.baseUnicodeString = new BMPString(this.baseString);
            return this.baseUnicodeString;
        }
        byte[] triples = new byte[uLength * 3];
        int j = 0;
        for (int i = 0; i < this.baseString.length(); ++i) {
            char c = this.baseString.charAt(i);
            if (UTF16CharacterSet.isSurrogate(c)) {
                int cp = UTF16CharacterSet.combinePair(c, this.baseString.charAt(++i));
                triples[j++] = (byte)(cp >> 16 & 0xFF);
                triples[j++] = (byte)(cp >> 8 & 0xFF);
                triples[j++] = (byte)(cp & 0xFF);
                continue;
            }
            triples[j++] = 0;
            triples[j++] = (byte)(c >> 8 & 0xFF);
            triples[j++] = (byte)(c & 0xFF);
        }
        this.baseUnicodeString = new Twine24(triples);
        return this.baseUnicodeString;
    }

    @Override
    public boolean isEmpty() {
        return this.baseString.isEmpty();
    }

    @Override
    public long estimatedLength() {
        return this.baseUnicodeString != null ? this.baseUnicodeString.length() : (long)this.baseString.length();
    }

    @Override
    public long length() {
        return this.tidy().length();
    }

    @Override
    public int getWidth() {
        return this.tidy().getWidth();
    }

    @Override
    public long indexOf(int codePoint, long from) {
        return this.tidy().indexOf(codePoint, from);
    }

    @Override
    public int codePointAt(long index) {
        return this.tidy().codePointAt(index);
    }

    @Override
    public UnicodeString substring(long start, long end) {
        return this.tidy().substring(start, end);
    }

    @Override
    public IntIterator codePoints() {
        return this.baseUnicodeString != null ? this.baseUnicodeString.codePoints() : StringTool.codePoints(this.baseString);
    }

    @Override
    public UnicodeString concat(UnicodeString other) {
        if (other instanceof StringView) {
            StringView sv = new StringView(this.baseString + ((StringView)other).baseString);
            UnicodeString us1 = this.baseUnicodeString;
            UnicodeString us2 = ((StringView)other).baseUnicodeString;
            if (us1 != null && us2 != null) {
                this.baseUnicodeString = us1.concat(us2);
            }
            return sv;
        }
        UnicodeBuilder ub = new UnicodeBuilder();
        return ub.accept(this).accept(other).toUnicodeString();
    }

    @Override
    public int compareTo(UnicodeString other) {
        if (this.baseUnicodeString != null && other instanceof StringView && ((StringView)other).baseUnicodeString != null) {
            return this.baseString.compareTo(((StringView)other).baseString);
        }
        return super.compareTo(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StringView) {
            return this.baseString.equals(((StringView)obj).baseString);
        }
        if (obj instanceof BMPString) {
            return this.baseString.equals(obj.toString());
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.baseString.hashCode();
    }

    @Override
    public UnicodeString economize() {
        return this.tidy();
    }

    public String toString() {
        return this.baseString;
    }

    @Override
    void copy8bit(byte[] target, int offset) {
        this.tidy().copy8bit(target, offset);
    }

    @Override
    void copy16bit(char[] target, int offset) {
        this.tidy().copy16bit(target, offset);
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        this.tidy().copy24bit(target, offset);
    }
}

