/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RelationshipMappingTypeCritic
extends CriticAndSettings {
    public RelationshipMappingTypeCritic() {
        super(CriticAndSettings.StarterPlatformTypes.GENERIC.getName(), Messages.getString("RelationshipMappingTypeCritic.name"));
    }

    @Override
    public List<Criticism> criticize(Object so) {
        if (!(so instanceof SQLRelationship.ColumnMapping)) {
            return Collections.emptyList();
        }
        SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)so;
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (ArchitectUtils.columnsDiffer(cm.getFkColumn(), cm.getPkColumn())) {
            final SQLColumn parentColumn = cm.getPkColumn();
            SQLTable parentTable = parentColumn.getParent();
            final SQLColumn childColumn = cm.getFkColumn();
            SQLTable childTable = childColumn.getParent();
            final UserDefinedSQLType parentSQLType = parentColumn.getUserDefinedSQLType();
            String updateToParentQuickFix = "Change type of " + childTable.getName() + "." + childColumn.getName() + " (child column) to " + parentSQLType.getUpstreamType().getName() + (parentSQLType.getPrecisionType("GENERIC").equals((Object)SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) ? "" : "(" + parentSQLType.getPrecision("GENERIC") + (parentSQLType.getScaleType("GENERIC").equals((Object)SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) ? "" : ", " + parentSQLType.getScale("GENERIC")) + ")");
            UserDefinedSQLType childSQLType = childColumn.getUserDefinedSQLType();
            String updateToChildQuickFix = "Change type of " + parentTable.getName() + "." + parentColumn.getName() + " (parent column) to " + childSQLType.getUpstreamType().getName() + (childSQLType.getPrecisionType("GENERIC").equals((Object)SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) ? "" : "(" + childSQLType.getPrecision("GENERIC") + (childSQLType.getScaleType("GENERIC").equals((Object)SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) ? "" : ", " + childSQLType.getScale("GENERIC")) + ")");
            criticisms.add(new Criticism(cm.getParent(), "Columns " + cm.getPkColumn().getShortDisplayName() + " and " + cm.getFkColumn().getShortDisplayName() + " related by FK constraint " + "have different types, scale, or precision", this, new CriticFix(updateToParentQuickFix, CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    UserDefinedSQLType typeToUpdate = childColumn.getUserDefinedSQLType();
                    UserDefinedSQLType typeToMatch = parentSQLType;
                    typeToUpdate.setUpstreamType(typeToMatch.getUpstreamType());
                    childColumn.setType(parentColumn.getType());
                    childColumn.setPrecision(parentColumn.getPrecision());
                    childColumn.setScale(parentColumn.getScale());
                }
            }, new CriticFix(updateToChildQuickFix, CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    UserDefinedSQLType typeToUpdate = parentColumn.getUserDefinedSQLType();
                    UserDefinedSQLType typeToMatch = childColumn.getUserDefinedSQLType();
                    typeToUpdate.setUpstreamType(typeToMatch.getUpstreamType());
                    parentColumn.setType(childColumn.getType());
                    parentColumn.setPrecision(childColumn.getPrecision());
                    parentColumn.setScale(childColumn.getScale());
                }
            }));
        }
        return criticisms;
    }
}

