/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.internal.filter;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Component(configurationPid={"org.openhab.proxyfilter"})
@JaxrsExtension
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@NonNullByDefault
public class ProxyFilter
implements ContainerRequestFilter {
    static final String PROTO_PROXY_HEADER = "x-forwarded-proto";
    static final String HOST_PROXY_HEADER = "x-forwarded-host";
    private final transient Logger logger = LoggerFactory.getLogger(ProxyFilter.class);

    public void filter(@NonNullByDefault(value={}) ContainerRequestContext ctx) throws IOException {
        URI newBaseUri;
        Object host = this.getValue((MultivaluedMap<String, String>)ctx.getHeaders(), HOST_PROXY_HEADER);
        String scheme = this.getValue((MultivaluedMap<String, String>)ctx.getHeaders(), PROTO_PROXY_HEADER);
        if (scheme == null && host == null) {
            return;
        }
        UriInfo uriInfo = ctx.getUriInfo();
        URI requestUri = uriInfo.getRequestUri();
        UriBuilder baseBuilder = uriInfo.getBaseUriBuilder();
        UriBuilder requestBuilder = uriInfo.getRequestUriBuilder();
        if (scheme == null) {
            scheme = requestUri.getScheme();
        }
        if (host == null) {
            host = requestUri.getHost();
            int port = requestUri.getPort();
            if (port != -1) {
                host = (String)host + ":" + port;
            }
        }
        if (((String)host).indexOf(",") > 0) {
            host = ((String)host).substring(0, ((String)host).indexOf(","));
        }
        String uriString = scheme + "://" + ((String)host).trim();
        try {
            newBaseUri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            this.logger.error("Invalid X-Forwarded-Proto + X-Forwarded-Host header combination: {}", (Object)uriString, (Object)e);
            return;
        }
        host = newBaseUri.getHost();
        if (host != null) {
            baseBuilder.host((String)host);
            requestBuilder.host((String)host);
        }
        int port = newBaseUri.getPort();
        baseBuilder.port(port);
        requestBuilder.port(port);
        scheme = newBaseUri.getScheme();
        if (scheme != null) {
            baseBuilder.scheme(scheme);
            requestBuilder.scheme(scheme);
        }
        ctx.setRequestUri(baseBuilder.build(new Object[0]), requestBuilder.build(new Object[0]));
    }

    private @Nullable String getValue(MultivaluedMap<String, String> headers, String header) {
        List values = (List)headers.get((Object)header);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.getFirst();
    }
}

