/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.openhab.core.model.items.ItemsPackage;
import org.openhab.core.model.items.ModelItem;
import org.openhab.core.model.validation.AbstractItemsValidator;
import org.openhab.core.types.util.UnitUtils;

public class ItemsValidator
extends AbstractItemsValidator {
    @Check
    public void checkItemName(ModelItem item) {
        if (item == null || item.getName() == null) {
            return;
        }
        boolean _contains = item.getName().contains("-");
        if (_contains) {
            this.error("Item name must not contain dashes.", (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__NAME);
        }
    }

    @Check
    public void checkDimension(ModelItem item) {
        if (item == null || item.getType() == null) {
            return;
        }
        boolean _startsWith = item.getType().startsWith("Number:");
        if (_startsWith) {
            String _type = item.getType();
            int _indexOf = item.getType().indexOf(":");
            int _plus = _indexOf + 1;
            String dimension = _type.substring(_plus);
            try {
                UnitUtils.parseDimension((String)dimension);
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    this.warning("'" + dimension + "' is not a valid dimension.", (EStructuralFeature)ItemsPackage.Literals.MODEL_ITEM__TYPE);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }
}

