/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class ExplicitSqlStringGenerationContext
implements SqlStringGenerationContext {
    private final SessionFactoryImplementor factory;
    private final Identifier defaultCatalog;
    private final Identifier defaultSchema;

    public ExplicitSqlStringGenerationContext(String defaultCatalog, String defaultSchema, SessionFactoryImplementor factory) {
        this.factory = factory;
        this.defaultCatalog = defaultCatalog != null ? this.toIdentifier(defaultCatalog) : this.toIdentifier(factory.getSessionFactoryOptions().getDefaultCatalog());
        this.defaultSchema = defaultSchema != null ? this.toIdentifier(defaultSchema) : this.toIdentifier(factory.getSessionFactoryOptions().getDefaultSchema());
    }

    private JdbcEnvironment getJdbcEnvironment() {
        return this.factory.getJdbcServices().getJdbcEnvironment();
    }

    @Override
    public Dialect getDialect() {
        return this.factory.getJdbcServices().getDialect();
    }

    @Override
    public Identifier toIdentifier(String text) {
        return this.getJdbcEnvironment().getIdentifierHelper().toIdentifier(text);
    }

    @Override
    public Identifier getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public Identifier getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public String format(QualifiedTableName qualifiedName) {
        return this.nameFormater().format(this.withDefaults(qualifiedName), this.getDialect());
    }

    private QualifiedObjectNameFormatter nameFormater() {
        return this.getJdbcEnvironment().getQualifiedObjectNameFormatter();
    }

    @Override
    public String format(QualifiedSequenceName qualifiedName) {
        return this.nameFormater().format(this.withDefaults(qualifiedName), this.getDialect());
    }

    @Override
    public String format(QualifiedName qualifiedName) {
        return this.nameFormater().format(this.withDefaults(qualifiedName), this.getDialect());
    }

    @Override
    public String formatWithoutCatalog(QualifiedSequenceName qualifiedName) {
        QualifiedSequenceName nameToFormat = qualifiedName.getCatalogName() != null || qualifiedName.getSchemaName() == null && this.defaultSchema != null ? new QualifiedSequenceName(null, this.schemaWithDefault(qualifiedName.getSchemaName()), qualifiedName.getSequenceName()) : qualifiedName;
        return this.nameFormater().format(nameToFormat, this.getDialect());
    }

    @Override
    public boolean isMigration() {
        return false;
    }
}

