/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.store.ldap.extended;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;

public final class PasswordModifyRequest
implements ExtendedRequest {
    public static final String PASSWORD_MODIFY_OID = "1.3.6.1.4.1.4203.1.11.1";
    private static final byte SEQUENCE_TYPE = 48;
    private static final byte USER_IDENTITY_OCTET_TYPE = -128;
    private static final byte OLD_PASSWORD_OCTET_TYPE = -127;
    private static final byte NEW_PASSWORD_OCTET_TYPE = -126;
    private final ByteArrayOutputStream value = new ByteArrayOutputStream();

    public PasswordModifyRequest(String userIdentity, String oldPassword, String newPassword) {
        ByteArrayOutputStream elements = new ByteArrayOutputStream();
        if (userIdentity != null) {
            this.berEncode((byte)-128, userIdentity.getBytes(), elements);
        }
        if (oldPassword != null) {
            this.berEncode((byte)-127, oldPassword.getBytes(), elements);
        }
        if (newPassword != null) {
            this.berEncode((byte)-126, newPassword.getBytes(), elements);
        }
        this.berEncode((byte)48, elements.toByteArray(), this.value);
    }

    @Override
    public String getID() {
        return PASSWORD_MODIFY_OID;
    }

    @Override
    public byte[] getEncodedValue() {
        return this.value.toByteArray();
    }

    @Override
    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) {
        return null;
    }

    private void berEncode(byte type, byte[] src, ByteArrayOutputStream dest) {
        int length = src.length;
        dest.write(type);
        if (length < 128) {
            dest.write(length);
        } else if ((length & 0xFF) == length) {
            dest.write(-127);
            dest.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFF) == length) {
            dest.write(-126);
            dest.write((byte)(length >> 8 & 0xFF));
            dest.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFFFF) == length) {
            dest.write(-125);
            dest.write((byte)(length >> 16 & 0xFF));
            dest.write((byte)(length >> 8 & 0xFF));
            dest.write((byte)(length & 0xFF));
        } else {
            dest.write(-124);
            dest.write((byte)(length >> 24 & 0xFF));
            dest.write((byte)(length >> 16 & 0xFF));
            dest.write((byte)(length >> 8 & 0xFF));
            dest.write((byte)(length & 0xFF));
        }
        try {
            dest.write(src);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to BER encode provided value of type: " + type);
        }
    }
}

