/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class LimitOutputStream
extends FilterOutputStream {
    private final byte[] _buf1;
    protected final DoneCallback _callback;
    protected boolean _isDone;

    public LimitOutputStream(OutputStream out, DoneCallback done) {
        super(out);
        this._callback = done;
        this._buf1 = new byte[1];
    }

    @Override
    public void write(int c) throws IOException {
        this._buf1[0] = (byte)c;
        this.write(this._buf1, 0, 1);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    protected boolean isDone() {
        return this._isDone;
    }

    protected void setDone() throws IOException {
        if (this._isDone) {
            throw new IllegalStateException("already done");
        }
        this.flush();
        this._callback.streamDone();
        this._isDone = true;
    }

    public static interface DoneCallback {
        public void streamDone();
    }
}

