.\" $Header: /home/amb/wwwoffle/doc/RCS/wwwoffle.conf.man.template 2.79 2001/09/04 19:13:21 amb Exp $
.\"
.\"  WWWOFFLE - World Wide Web Offline Explorer - Version 2.7.
.\"
.\"  Manual page for wwwoffle.conf
.\"
.\"  Written by Andrew M. Bishop
.\"
.\"  This file Copyright 1997,98,99,2000,01 Andrew M. Bishop
.\"  It may be distributed under the GNU Public License, version 2, or
.\"  any higher version.  See section COPYING of the GNU Public license
.\"  for conditions under which this file may be redistributed.
.\"
.TH wwwoffle.conf 5 "May 23, 2001"

.SH NOM

wwwoffle.conf \- Le fichier de configuration du serveur proxy WWWOFFLE.


.SH Introduction

Le fichier de configuration (
.I wwwoffle\.conf
) spcifie tous les paramtres qui
contrlent l\'activit du serveur proxy\. Le fichier est divis en sections
dcrites ci\-dessous contenant chacune une srie de paramtres\. Le fichier
.I CHANGES\.CONF
explique les changements de ce fichier de configuration par rapport
aux versions prcdentes\.
.LP
Le fichier est divis en sections, chacune pouvant tre vide ou contenir une ou
plusieurs lignes d\'information de configuration\. Les sections sont nommes, et
leur ordre d\'apparition dans le fichier n\'est pas important\.
.LP
Le format gnral de chacune des sections est le mme\. Le nom de la section est
sur une ligne, et en marque le dbut\. Le contenu de la section est dlimit par
une paire de lignes contenant seulement les caractres \'{\' et \'}\', ou \'[\' et
\']\'\. Quand la paire \'{\' et \'}\' est utilise, les lignes encloses contiennent des
informations de configuration\. Quand la paire \'[\' et \']\' est utilise, il doit y
avoir  l\'intrieur de cette dernire une seule ligne non vide, contenant le nom
d\'un fichier (dans le mme rpertoire) contenant les lignes de configuration de
cette section\.
.LP
Les commentaires sont signals par le caractre \'#\' au dbut de la ligne, et
sont ignors\. Les lignes vides sont aussi permises et ignores\.
.LP
Les entits 
.I URL\-SPECIFICATION
(
.I URL\-SPEC
en abrg) et 
.I WILDCARD
ont une
signification particulire dans le fichier de configuration, et sont dcrites 
la fin\. Toute entit enclose entre parenthses \'(\' et \')\' dans les descriptions
signifie un paramtre fourni par l\'utilisateur, tout ce qui est entre crochets
\'[\' et \']\' est optionnel, et la barre verticale \'|\' indique une
alternative\. Certaines options s\'appliquent seulement  des URL, ceci est
prcis par une 
.I URL\-SPECIFICATION
enclose entre \'<\' & \'>\' dans l\'option, la
premire 
.I URL\-SPECIFICATION
qui correspond au motif est utilise\. Si aucune
.I URL\-SPECIFICATION
n\'est donne, alors toute URL correspond\.

.SH StartUp

Cette section contient les paramtres utiliss au lancement du programme, les
changements ventuels sont ignors si la configuration est relue pendant
l\'excution\.
.TP
.B bind\-ipv4 = (hostname) | (ip\-address) | none
Spcifie le nom d\'hte ou l\'adresse IP o lier les sockets proxy HTTP et port
de contrle WWWOFFLE utilisant IPv4 (par dfaut \'0\.0\.0\.0\')\. Si \'none\'
est indiqu, alors aucun socket IPv4 n\'est utilis\.
.TP
.B bind\-ipv6 = (hostname) | (ip\-address) | none
Spcifie le nom d\'hte ou l\'adresse IP o lier les sockets proxy HTTP et port
de contrle WWWOFFLE utilisant IPv6 (par dfaut \'::\')\. Si \'none\'
est indiqu, alors aucun socket IPV6 n\'est utilis\. L\'option de
compilation IPv6 est requise\.
.TP
.B http\-port = (port)
Un entier indiquant le port du serveur proxy (8080 par dfaut)\.
.TP
.B wwwoffle\-port = (port)
Un entier indiquant le port de contrle WWWOFFLE (8081 par dfaut)\.
.TP
.B spool\-dir = (dir)
Le chemin complet du rpertoire de cache (rpertoire de spool)
(dfaut=/var/spool/wwwoffle)\.
.TP
.B run\-uid = (user) | (uid)
Le nom d\'utilisateur ou le numro UID sous lequel le serveur WWWOFFLE
est lanc (dfaut=aucun)\. Cette option n\'est pas applicable sous win32
et ne fonctionne que si le serveur est lanc par l\'utilisateur root sous
UNIX\.
.TP
.B run\-gid = (group) | (gid)
Le groupe ou le numro GID sous lequel le serveur WWWOFFLE est lanc
(dfaut=aucun)\. Cette option n\'est pas applicable sous win32, et ne
fonctionne que si le serveur est lanc par l\'utilisateur root sous UNIX\.
.TP
.B use\-syslog = yes | no
Indique si le service syslog est utilis pour les messages (dfaut=yes)\.
.TP
.B password = (word)
Le mot de passe utilis pour l\'authentification des pages de contrle,
pour l\'effacement des pages mmorises, etc\. (dfaut=aucun)\. Pour
scuriser la configuration, la lecture du fichier de configuration doit
tre rserve aux utilisateurs autoriss\.
.TP
.B max\-servers = (integer)
Le nombre maximum de processus serveurs lancs en ligne et pour le
rapatriement automatique (dfaut=8)\.
.TP
.B max\-fetch\-servers = (integer)
Le nombre maximum de serveurs lancs pour le rapatriement automatique
des pages demandes en mode hors\-ligne (dfaut=4)\. Cette valeur doit
tre infrieure  max\-servers pour permettre l\'usage interactif
simultan\.

.SH Options

Options contrlant le fonctionnement du programme
.TP
.B log\-level = debug | info | important | warning | fatal
Le niveau minimum de message syslog ou stderr (dfaut=important)\.
.TP
.B socket\-timeout = (time)
Le temps d\'attente en secondes des donnes sur un socket avant abandon
par WWWOFFLE (dfaut=120)\.
.TP
.B dns\-timeout = (time)
Le temps d\'attente en secondes d\'une requte DNS (Domain Name Service)
avant abandon par WWWOFFLE (dfaut=60)\.
.TP
.B connect\-timeout = (time)
Le temps d\'attente en secondes pour obtenir un socket avant abandon par
WWWOFFLE (dfaut=30)\.
.TP
.B connect\-retry = yes | no
Si une connexion  un serveur distant ne peut tre obtenue, alors
WWWOFFLE essaiera encore aprs un court dlai (dfaut=no)\.
.TP
.B ssl\-allow\-port = (integer)
Un numro de port autoris pour les connexions SSL (Secure Socket
Layer), par ex\. https\. Cette option devrait tre fixe  443 pour
autoriser https, il peut y avoir plusieurs lignes ssl pour autoriser
d\'autres ports si besoin\.
.TP
.B dir\-perm = (octal int)
Les permissions de rpertoires pour la cration des rpertoires de spool
(dfaut=0755)\. Cette option crase le umask de l\'utilisateur, et doit
tre octale, commenant par un zro \'0\'\.
.TP
.B file\-perm = (octal int)
Les permissions de fichiers pour la cration des fichiers de spool
(dfaut=0644)\. Cette option crase le umask de l\'utilisateur, et doit
tre octale, commenant par un zro \'0\'\.
.TP
.B run\-online = (filename)
Le nom d\'un programme  lancer quand WWWOFFLE est commut en mode en
ligne (dfaut=aucun)\. Ce programme est lanc avec un seul paramtre,
fix au nom du mode, "online"\.
.TP
.B run\-offline = (filename)
Le nom du programme  lancer quand WWWOFFLE est commut en mode
hors\-ligne (dfaut=aucun)\. Ce programme est lanc avec un seul
paramtre, le nom du mode, "offline"\.
.TP
.B run\-autodial = (filename)
Le nom d\'un programme  lancer quand WWWOFFLE est commut en mode
automatique (dfaut=aucun)\. Le programme est lanc avec un seul
paramtre, le nom du mode, "autodial"\.
.TP
.B run\-fetch = (filename)
Le nom du programme  lancer quand WWWOFFLE dmarre ou arrte le
rapatriement automatique (dfaut=aucun)\. Ce programme est lanc avec
deux paramtres, le premier le mot "fetch", et le second l\'un des mots
"start" ou "stop"\.
.TP
.B lock\-files = yes | no
Active l\'usage des fichiers verrous pour empcher plus d\'un processus
WWWOFFLE de rapatrier simultanment la mme URL (dfaut=no)\.
.TP
.B reply\-compressed\-data = yes | no
Si les rponses faites au navigateur doivent contenir des donnes
compresses quand demand (dfaut=no)\. Ncessite l\'option de compilation
zlib\.

.SH OnlineOptions

Options contrlant le comportement en ligne de WWWOFFLE\.
.TP
.B [<URL\-SPEC>] request\-changed = (time)
En ligne, les pages ne seront rapatries que si la version mmorise est
plus ancienne que le temps indiqu en secondes (dfaut=600)\. Une valeur
ngative indique que les pages mmorises sont toujours utilises en
ligne\. Des temps longs peuvent tre indiqus par les suffixes \'m\', \'h\',
\'d\' ou \'w\' pour minute, heure, jour ou semaine (par ex\. 10m=600)\.
.TP
.B [<URL\-SPEC>] request\-changed\-once = yes | no
En ligne, les pages ne seront rapatries qu\'une seule fois par session
(dfaut=yes)\. Cette option a priorit sur l\'option request\-changed\.
.TP
.B [<URL\-SPEC>] request\-expired = yes | no
En ligne, les pages primes seront rafrachies (dfaut=no)\. Cette option
a priorit sur les options request\-changed et request\-changed\-once\.
.TP
.B [<URL\-SPEC>] request\-no\-cache = yes | no
En ligne, les pages  ne pas cacher seront toujours redemandes
(dfaut=no)\. Cette option a priorit sur les options request\-changed et
request\-changed\-once\.
.TP
.B [<URL\-SPEC>] try\-without\-password = yes | no
Si une requte demande une page utilisant un nom et un mot de passe,
alors une requte de la mme page sera faite sans (dfaut=yes)\. Ceci
autorise la requte d\'une page sans mot de passe  tre redirige vers
la version avec\.
.TP
.B [<URL\-SPEC>] intr\-download\-keep = yes | no
Si le navigateur ferme la connexion en ligne, alors la page incomplte
sera conserve (dfaut=no)\.
.TP
.B [<URL\-SPEC>] intr\-download\-size = (integer)
Si le navigateur ferme la connexion en ligne, la page devrait continuer
 tre rapatrie si sa taille est infrieure  celle indique en
kilo\-octets (dfaut=1)\.
.TP
.B [<URL\-SPEC>] intr\-download\-percent = (integer)
Si le navigateur ferme la connexion en ligne, la page devrait continuer
 tre rapatrie si le pourcentage indiqu est atteint (dfaut=80)\.
.TP
.B [<URL\-SPEC>] timeout\-download\-keep = yes | no
Si la connexion au serveur est abandonne, la page incomplte doit tre
conserve (dfaut=no)\.
.TP
.B [<URL\-SPEC>] request\-compressed\-data = yes | no
Si les requtes aux serveurs doivent demander des donnes compresses
(dfaut=yes)\. Ncessite l\'option de compilation zlib\.

.SH OfflineOptions

Options contrlant le comportement hors ligne de WWWOFFLE\.
.TP
.B [<URL\-SPEC>] pragma\-no\-cache = yes | no
Indique s\'il faut rafrachir une copie si la requte du navigateur a
l\'option \'Pragma: no\-cache\' (dfaut=yes)\. Cette option doit tre  \'no\'
si hors ligne toutes les pages sont redemandes par un navigateur
dfectueux\.
.TP
.B [<URL\-SPEC>] confirm\-requests = yes | no
Indique s\'il faut renvoyer une page de confirmation au lieu
d\'enregistrer automatiquement les demandes faites hors ligne
(dfaut=no)\.
.TP
.B [<URL\-SPEC>] dont\-request = yes | no
Ne pas demander hors ligne une URL de ce modle (dfaut=no)\.

.SH FetchOptions

Options contrlant le rapatriement de pages demandes hors ligne\.
.TP
.B [<URL\-SPEC>] stylesheets = yes | no
Rapatriement des feuilles de style (dfaut=no)\.
.TP
.B [<URL\-SPEC>] images = yes | no
Rapatriement des images (dfaut=no)\.
.TP
.B [<URL\-SPEC>] webbug\-images = yes | no
Rapatriement des imagettes d\'un seul pixel, ncessite que l\'option image
soit aussi active (dfaut=yes)\. Cette option est conue pour tre
utilise avec l\'option replace\-webbug\-images de la section ModifyHTML\.
.TP
.B [<URL\-SPEC>] frames = yes | no
Rapatriement des cadres (dfaut=no)\.
.TP
.B [<URL\-SPEC>] scripts = yes | no
Rapatriement des scripts (par ex\. Javascript) (dfaut=no)\.
.TP
.B [<URL\-SPEC>] objects = yes | no
Rapatriement des objets (par ex\. fichier de classe Java) (dfaut=no)\.

.SH IndexOptions

Options contrlant l\'affichage des index\.
.TP
.B no\-lasttime\-index = yes | no
Supprime la cration des index des sessions prcdentes (dfaut=no)\.
.TP
.B cycle\-indexes\-daily = yes | no
Rotation quotidienne des index des sessions et demandes prcdentes
au lieu de pour chaque connexion (dfaut=no)\.
.TP
.B <URL\-SPEC> list\-outgoing = yes | no
Indique s\'il faut afficher ce type d\'URL dans les demandes (dfaut=yes)\.
.TP
.B <URL\-SPEC> list\-latest = yes | no
Indique s\'il faut afficher ce type d\'URL dans les sessions et demandes
prcdentes (dfaut=yes)\.
.TP
.B <URL\-SPEC> list\-monitor = yes | no
Indique s\'il faut afficher ce type d\'URL dans la liste des pages 
surveiller priodiquement (dfaut=yes)\.
.TP
.B <URL\-SPEC> list\-host = yes | no
Indique s\'il faut afficher ce type d\'URL dans les listes par site
(dfaut=yes)\.
.TP
.B <URL\-SPEC> list\-any = yes | no
Indique s\'il faut afficher ce type d\'URL dans toutes les listes
(dfaut=yes)\.

.SH ModifyHTML

Options contrlant la modification du HTML mmoris\.
.TP
.B [<URL\-SPEC>] enable\-modify\-html = yes | no
Active la modification du HTML dans cette section (dfaut=no)\. Sans
cette option, les suivantes resteront sans effet\. Avec cette option, il
y aura un petit ralentissement\.
.TP
.B [<URL\-SPEC>] add\-cache\-info = yes | no
 la fin des pages mmorises apparatra la date et quelques liens
(dfaut=no)\.
.TP
.B [<URL\-SPEC>] anchor\-cached\-begin = (HTML code) |
Ce code HTML sera insr avant les liens des pages mmorises
(dfaut="")\.
.TP
.B [<URL\-SPEC>] anchor\-cached\-end = (HTML code) |
Ce code HTML sera insr aprs les liens des pages mmorises
(dfaut="")\.
.TP
.B [<URL\-SPEC>] anchor\-requested\-begin = (HTML code) |
Ce code HTML sera insr avant les liens vers des pages demandes
(dfaut="")\.
.TP
.B [<URL\-SPEC>] anchor\-requested\-end = (HTML code) |
Ce code HTML sera insr aprs les liens vers des pages demandes
(dfaut="")\.
.TP
.B [<URL\-SPEC>] anchor\-not\-cached\-begin = (HTML code) |
Ce code HTML sera insr avant les liens vers des pages ni prsentes ni
demandes (dfaut="")\.
.TP
.B [<URL\-SPEC>] anchor\-not\-cached\-end = (HTML code) |
Ce code HTML sera insr aprs les liens vers des pages ni prsentes ni
demandes (dfaut="")\.
.TP
.B [<URL\-SPEC>] disable\-script = yes | no
Supprime tous les scripts et vnements (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-applet = yes | no
Supprime toutes les applets Java (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-style = yes | no
Supprime toutes les feuilles de style et leurs rfrences (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-blink = yes | no
Supprime les balises de clignotement (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-flash = yes | no
Supprime les animations Shockwave Flash (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-meta\-refresh = yes | no
Supprime les balises d\'en\-tte HTML qui redirigent le navigateur vers
une autre page aprs un dlai (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-meta\-refresh\-self = yes | no
Supprime les balises d\'en\-tte HTML qui indiquent au navigateur de
recharger la mme page aprs un dlai (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-dontget\-links = yes | no
Supprime les liens vers une URL de la section DontGet (dfaut=no)\.
.TP
.B [<URL\-SPEC>] disable\-dontget\-iframes = yes | no
Supprime les liens des URL de cadres de la section DontGet (dfaut=no)\.
.TP
.B [<URL\-SPEC>] replace\-dontget\-images = yes | no
Remplace les URL d\'images de la section DontGet par une URL fixe
(dfaut=no)\.
.TP
.B [<URL\-SPEC>] replacement\-dontget\-image = (URL)
L\'image de remplacement  utiliser pour les URL de la section DontGet
(dfaut=/local/dontget/replacement\.gif)\.
.TP
.B [<URL\-SPEC>] replace\-webbug\-images = yes | no
Remplace les URL d\'imagettes d\'un pixel par une URL fixe (dfaut=no)\.
Cette option est conue pour tre utilise avec l\'option webbug\-images
de la section FetchOptions\.
.TP
.B [<URL\-SPEC>] replacement\-webbug\-image = (URL)
L\'image de remplacement des imagettes d\'un pixel
(dfaut=/local/dontget/replacement\.gif)\.
.TP
.B [<URL\-SPEC>] disable\-animated\-gif = yes | no
Supprime l\'animation des images GIF animes (dfaut=no)\.
.TP
.B [<URL\-SPEC>] demoronise\-ms\-chars = yes | no
Remplace quelques caractres tranges insrs par quelques applications
Microsoft par des caractres que la majorit des navigateurs peut
afficher (dfaut=no)\. Cette ide provient du script Perl Demoroniser, du
domaine public\.

.SH LocalHost

Une liste de noms sous lequel l\'hte du serveur WWWOFFLE peut tre connu\. Ceci
permet d\'viter que ce dernier ne se contacte lui\-mme sous un autre nom\.
.TP
.B (host)
Un nom ou une adresse IP qui avec le numro de port (cf\. section
StartUp) indique le serveur proxy WWWOFFLE\. Les noms doivent
correspondre exactement, ce n\'est pas un patron modle\. Le premier nomm
est utilis comme nom du serveur pour plusieurs choses et doit donc tre
un nom fonctionnel pour tous les clients du rseau\. Aucun nom ainsi
indiqu n\'abrite de page mmorise ou rapatrie par le proxy\.

.SH LocalNet

Une liste de noms dont les serveurs web sont toujours accessibles mme hors
ligne, et dont les pages ne sont pas mmorises par WWWOFFLE car sur le rseau local\.
.TP
.B (host)
Un nom nom ou adresse IP toujours accessible et dont les pages ne sont
pas mmorises par WWWOFFLE\. La reconnaissance de ce nom ou adresse
utilise un patron modle\. Un hte peut tre exclu en le prfixant par un
point d\'exclamation \'!\', tous les alias et adresses IP possibles sont
aussi requis\. Toutes ces entres sont supposes toujours accessibles
mme hors ligne\. Aucun des htes ainsi mentionns n\'a de page mmorise\.

.SH AllowedConnectHosts

Une liste de clients autoriss  se connecter au serveur\.
.TP
.B (host)
Un nom d\'hte ou une adresse IP autoris  se connecter au serveur\. La
reconnaissance de ce nom ou adresse utilise un patron modle\. Un hte
peut tre exclu en le prfixant par un point d\'interrogation \'!\', tous
les alias et adresses IP sont aussi requis\. Tous les htes de la section
LocalHost sont aussi autoriss\.

.SH AllowedConnectUsers

Une liste des utilisateurs autoriss  se connecter et leurs mots de passe\.
.TP
.B (username):(password)
Le nom (login) et le mot de passe des utilisateurs autoriss  se
connecter au serveur\. Si cette section est laisse vide, il n\'y a pas
d\'authentification\. Le nom et le mot de passe sont inscrits en
clair\. Ceci requiert l\'utilisation de navigateurs respectant le standard
d\'authentification HTTP/1\.1

.SH DontCache

Une liste d\'URL non mmorises par WWWOFFLE\.
.TP
.B [!]URL\-SPECIFICATION
Ne mmorise aucune URL correspondant  ce modle\. L\'
.I URL\-SPECIFICATION

peut tre exclue pour autoriser la mmorisation\. Les URL ne seront pas
enregistres hors ligne\.

.SH DontGet

Une liste d\'URL qui ne seront pas rapatries par WWWOFFLE (parce qu\'elles ne
contiennent que des publicits, par exemple)\.
.TP
.B [!]URL\-SPECIFICATION
Ne pas rapatrier une URL conforme  ce modle\. L\'exclusion permet
le rapatriement\.
.TP
.B [<URL\-SPEC>] replacement = (URL)
L\'URL de remplacement des URL conformes  
.I URL\-SPEC
,  la place du
message d\'erreur standard (dfaut=none)\. Les URL du rpertoire
/local/dontget/ sont suggres pour cet office (par ex\. replacement\.gif,
replacement\.png qui sont des images d\'un seul pixel transparent, ou
replacement\.js qui est un fichier javascript vide)\.
.TP
.B <URL\-SPEC> get\-recursive = yes | no
Indique si les URL de ce modle doit tre rapatries rcursivement
(dfaut=yes)\.
.TP
.B <URL\-SPEC> location\-error = yes | no
Quand une rponse d\'URL contient un en\-tte \'Location\' qui redirige vers
une URL  ne pas rapatrier (indique dans cette section), alors la
rponse est modifie en message d\'erreur (dfaut=no)\. Ceci empchera un
proxy de fournisseur d\'accs de rediriger les utilisateurs vers des
publicits si elles sont mentionnes dans cette section\.

.SH DontCompress

Une liste de types MIME et d\'extensions de nom de fichiers  ne pas compresser
par WWWOFFLE (parce qu\'elles sont dj compresses, ou n\'en valent pas la
peine)\. Requiert l\'option de compilation zlib\.
.TP
.B mime\-type = (mime\-type)/(subtype)
Le type MIME d\'une URL  ne pas comprimer dans le cache ou en servant
des pages compresses aux navigateurs\.
.TP
.B file\-ext = \.(file\-ext)
Une extension de fichier  ne pas demander compress  un serveur\.

.SH CensorHeader

Une liste d\'en\-ttes HTTP  enlever des requtes aux serveurs web et les
rponses qui en reviennent\.
.TP
.B [<URL\-SPEC>] (header) = yes | no | (string)
Un nom d\'en\-tte (par ex\. From, Cookie, Set\-Cookie, User\-Agent) et la
chane de remplacement (dfaut=no)\. L\'en\-tte est sensible  la casse,
et ne doit pas se terminer par un deux\-points \':\'\. La valeur "no"
signifie que cet en\-tte n\'est pas modifi, "yes" ou pas de chane peut
tre utilis pour supprimer cet en\-tte, et une chane remplace la
valeur de cet en\-tte\. Seuls les en\-ttes trouvs sont remplacs, aucun
nouvel en\-tte n\'est ajout\.
.TP
.B [<URL\-SPEC>] referer\-self = yes | no
Met l\'en\-tte Referer  la mme valeur que l\'URL demande (dfaut=no)\.
.TP
.B [<URL\-SPEC>] referer\-self\-dir = yes | no
Met l\'en\-tte Referer au nom du rpertoire de l\'URL demande
(dfaut=no)\. Cette option est prioritaire sur l\'option referer\-self\.

.SH FTPOptions

Options utilises pour le protocole FTP\.
.TP
.B anon\-username = (string)
Le nom d\'utilisateur FTP anonyme utilis (dfaut=anonymous)\.
.TP
.B anon\-password = (string)
Le mot de passe  utiliser pour le FTP anonyme (dfaut dtermin 
l\'excution)\. Si on utilise un coupe\-feu, la valeur peut tre invalide
pour le serveur FTP, et doit tre remplace\.
.TP
.B <URL\-SPEC> auth\-username = (string)
Le nom d\'utilisateur sur ces serveurs au lieu de l\'anonyme par dfaut\.
.TP
.B <URL\-SPEC> auth\-password = (string)
Le mot de passe  utiliser au lieu de celui par dfaut\.

.SH MIMETypes

Types MIME  utiliser en servant des fichiers qui ne sont pas rapatris sous le
protocole HTTP, ou pour les fichiers du serveur web incorpor\.
.TP
.B default = (mime\-type)/(subtype)
Type MIME par dfaut (dfaut=text/plain)\.
.TP
.B \.(file\-ext) = (mime\-type)/(subtype)
Type MIME associ  une extension\. Le point \'\.\' initial doit tre
prsent\. Si plus d\'une extension convient, la plus longue est choisie\.

.SH Proxy

Les noms des serveurs proxys externes  utiliser\.
.TP
.B [<URL\-SPEC>] proxy = (host[:port])
Le nom d\'hte et le port du proxy\.
.TP
.B <URL\-SPEC> auth\-username = (string)
Le nom d\'utilisateur  utiliser\. La spcification 
.I URL\-SPEC
correspond
ici au serveur proxy, et non  l\'URL demande\.
.TP
.B <URL\-SPEC> auth\-password = (string)
Le mot de passe  utiliser\. La spcification 
.I URL\-SPEC
correspond
ici au serveur proxy, et non  l\'URL demande\.
.TP
.B [<URL\-SPEC>] ssl = (host[:port])
Un serveur proxy utilis pour les connexions SSL (Secure Socket Layer),
par ex\. https\. Noter que seule la partie hte  de 
.I URL\-SPEC
est vrifie,
et le reste doit tre remplac par des jokers \'*\'\.

.SH Alias

Une liste d\'alias de remplacement de serveurs et chemins\. Aussi pour les
serveurs connus sous deux noms\.
.TP
.B URL\-SPECIFICATION = URL\-SPECIFICATION
Toute requte correspondant  la premire 
.I URL\-SPECIFICATION
sera
remplace par la seconde\. La correspondance doit tre exacte, il n\'y a
pas de patron, les arguments de l\'URL sont ignors\.

.SH Purge

La mthode pour dterminer les pages  purger, l\'ge par dfaut, l\'ge
spcifique  l\'hte des pages en jours, et la taille maximum du cache\.
.TP
.B use\-mtime = yes | no
La mthode utilise pour dcider des fichiers  purger, dernier accs
(atime) ou dernire modification (ctime) (dfaut=no)\.
.TP
.B max\-size = (size)
La taille maximale du cache en mga\-octets aprs la purge
(dfaut=0)\. Une valeur nulle signifie pas de limite\. Si cette option et
min\-free sont toutes deux utilises, la plus petite taille de cache est
choisie\. Cette option tient compte des URL jamais purges pour mesurer
la taille du cache, mais ne les supprime pas\.
.TP
.B min\-free = (size)
La taille minimale d\'espace libre en mga\-octets aprs la purge
(dfaut=0)\. Une taille nulle signifie aucune limite pour l\'espace
libre\. Si cette option et l\'option max\-size sont toutes deux utilises,
la plus petite taille de cache est choisie\. Cette option tient compte
des URL jamais purges pour le dcompte, mais ne les supprime pas\.
.TP
.B use\-url = yes | no
Si \'yes\' alors utilise l\'URL pour dcider de l\'ge, sinon utilise
seulement le protocole et l\'hte (dfaut=no)\.
.TP
.B del\-dontget = yes | no
Si \'yes\' alors supprime les pages correspondant  la section DontGet
(dfaut=no)\.
.TP
.B del\-dontcache = yes | no
Si \'yes\' alors supprime les pages correspondant  la section DontCache
(dfaut=no)\.
.TP
.B [<URL\-SPEC>] age = (age)
L\'ge maximum en jours dans le cache pour les URL correspondant 
.I URL\-SPEC
(dfaut=14)\. Un ge nul signifie ne pas garder, et ngatif ne
pas effacer\. 
.I URL\-SPECIFICATION
correspond seulement au protocole et 
l\'hte, sauf si l\'option use\-url est active\. Des temps plus longs
peuvent tre indiqus par les suffixes \'w\', \'m\' ou \'y\' pour semaine,
mois et anne (par ex\. 2w=14)\.
.TP
.B [<URL\-SPEC>] compress\-age = (age)
L\'ge maximum de stockage sans compression dans le cache pour les URL
correspondant  
.I URL\-SPEC
(dfaut=\-1)\. Requiert l\'option de compilation
zlib\. L\'ge a la mme signification que pour l\'option age\.

.SH WILDCARD

Une correspondance joker utilise le caractre \'*\' pour reprsenter un groupe
quelconque de caractres\.
.LP
Ceci est fondamentalement identique aux expressions en ligne de commande des
shells DOS ou UNIX, except le fait que \'*\' correspond aussi au caractre
\'/\'\.
.LP
Par exemple,
.TP
.B *.gif
correspond  foo.gif et bar.gif
.TP
.B *.foo.com
correspond  www.foo.com et ftp.foo.com
.TP
.B /foo/*
correspond  /foo/bar.html et /foo/bar/foobar.html

.SH URL-SPECIFICATION

En indiquant un hte, un protocole et un chemin dans de nombreuses sections, une
.I URL\-SPECIFICATION
peut tre utilise, c\'est un moyen de reconnatre une URL\.
.LP
Pour cette explication, une URL peut tre compose de cinq parties\.
.TP
.B proto
Le protocole utilis (par ex. 'http', 'ftp')
.TP
.B host
Le nom du serveur (par ex. 'www.gedanken.org.uk').
.TP
.B port
Le numro de port sur le serveur (par ex. 80 pour le HTTP).
.TP
.B path
Le chemin sur le serveur (par ex. '/bar.html') ou un nom de
rpertoire (par ex\. \'/foo/\')\.
.TP
.B args
Arguments de l'URL pour les scripts CGI, etc.
(par ex\. \'search=foo\')\.
.LP
Par exemple, prenons la page d\'accueil de WWWOFFLE,
http://www\.gedanken\.org\.uk/software/wwwoffle/
.LP
Le protocole est \'http\', l\'hte \'www\.gedanken\.org\.uk\', le port est celui
par dfaut (ici, 80), et le chemin est \'/software/wwwoffle/\'\.
.LP
En gnral, on crira (proto)://(host)[:(port)][/(path)[?(args)]]
.LP
o les crochets [] indiquent une partie optionnelle, et les parenthses () un
nom ou un numro fourni par l\'utilisateur\.
.LP
Ci dessous quelques exemples de 
.I URL\-SPECIFICATION
:
.TP
.B *://*/*
Tout protocole, tout hte, tout port, tout chemin, tous
arguments (ce qui revient  \'default\')\.
.TP
.B *://*/(path)
Tout protocole, tout hte, tout port, chemin prcis, tous
arguments\.
.TP
.B *://*/*.(ext)
Tout protocole, tout hte, tout port, extension prcise,
tous arguments\.
.TP
.B *://*/*?
Tout protocole, tout hte, tout port, tout chemin, pas
d\'arguments\.
.TP
.B *://*/(path)?*
Tout protocole, tout hte, tout port, chemin prcis, tous
arguments\.
.TP
.B *://(host)/*
Tout protocole, hte prcis, tout port, tout chemin, tous
arguments\.
.TP
.B (proto)://*/*
Protocole prcis, tout hte, tout port, tout chemin, tous
arguments\.
.LP
(proto)://(host)/*  Protocole et hte prciss, tout port, tout chemin, tous
arguments\.
.LP
(proto)://(host):/* Protocole et hte prciss, port par dfaut, tout chemin, tous
arguments\.
.LP
*://(host):(port)/* Tout protocole, hte et port prciss, tout chemin, tous
arguments\.
.LP
La correspondance des htes, chemins et arguments utilise les jokers dcrits
ci\-dessus\.
.LP
Dans quelques sections acceptant les 
.I URL\-SPECIFICATION
, celles\-ci peuvent tre
exclues en les prfixant d\'un point d\'exclamation \'!\'\. Cela signifie que la
comparaison renverra la valeur logique contraire  celle renvoye sans le \'!\'\.
Si toutes les 
.I URL\-SPECIFICATION
sont exclues, et qu\'on rajoute \'*://*/*\'  la
fin, le sens de la section est renvers\.


.SH EXEMPLE

 StartUp
 {
  http-port     = 8080
  wwwoffle-port = 8081
  spool-dir     = /var/spool/wwwoffle
  use-syslog    = yes
  password      =
 }

 Options
 {
  add-info-refresh  = no
  request-changed   = 3600
 }

 FetchOptions
 {
  images = yes
  frames = yes
 }

 LocalHost
 {
  wwwoffle.foo.com
  localhost
  127.0.0.1
 }

 DontGet
 [
  wwwoffle.DontGet.conf
 ]

 LocalNet
 {
  *.foo.com
 }

 AllowedConnectHosts
 {
  *.foo.com
 }

 Proxy
 {
  <http://foo.com/*> proxy = www-cache.foo.com:8080
 }

 Purge
 {
  max-size = 10
  age = 28
  <http://*.bar.com/*> age  = 7
 }

.SH FICHIERS

CONFDIR/wwwoffle.conf Le fichier de configuration de wwwoffled(8).
.LP
SPOOLDIR Le rpertoire de spool de WWWOFFLE.

.SH VOIR AUSSI

wwwoffle(1), wwwoffled(8).

.SH AUTEUR

Andrew M. Bishop 1996,97,98,99,2000,01
