/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openide.nodes.Children;
import org.openide.nodes.EntrySupportLazy;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Utilities;

final class EntrySupportLazyState {
    static final EntrySupportLazyState UNINITIALIZED = new EntrySupportLazyState();
    private final boolean inited;
    private final Thread initThread;
    private final boolean initInProgress;
    private final boolean mustNotifySetEntries;
    private final List<Children.Entry> entries;
    private final List<Children.Entry> visibleEntries;
    private final Map<Children.Entry, EntryInfo> entryToInfo;

    private EntrySupportLazyState() {
        this(false, null, false, false, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
    }

    private EntrySupportLazyState(boolean bl, Thread thread, boolean bl2, boolean bl3, List<Children.Entry> list, List<Children.Entry> list2, Map<Children.Entry, EntryInfo> map) {
        this.inited = bl;
        this.initThread = thread;
        this.initInProgress = bl2;
        this.mustNotifySetEntries = bl3;
        this.entries = list;
        this.visibleEntries = list2;
        this.entryToInfo = map;
    }

    final boolean isInited() {
        return this.inited;
    }

    final boolean isInitInProgress() {
        return this.initInProgress;
    }

    final Thread initThread() {
        return this.initThread;
    }

    final boolean isMustNotify() {
        return this.mustNotifySetEntries;
    }

    final List<Children.Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    final List<Children.Entry> getVisibleEntries() {
        return Collections.unmodifiableList(this.visibleEntries);
    }

    final Map<Children.Entry, EntryInfo> getEntryToInfo() {
        return Collections.unmodifiableMap(this.entryToInfo);
    }

    private EntrySupportLazyState cloneState() {
        try {
            return (EntrySupportLazyState)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    final EntrySupportLazyState changeInited(boolean bl) {
        return new EntrySupportLazyState(bl, this.initThread, this.initInProgress, this.mustNotifySetEntries, this.entries, this.visibleEntries, this.entryToInfo);
    }

    final EntrySupportLazyState changeThread(Thread thread) {
        return new EntrySupportLazyState(this.inited, thread, this.initInProgress, this.mustNotifySetEntries, this.entries, this.visibleEntries, this.entryToInfo);
    }

    final EntrySupportLazyState changeProgress(boolean bl) {
        return new EntrySupportLazyState(this.inited, this.initThread, bl, this.mustNotifySetEntries, this.entries, this.visibleEntries, this.entryToInfo);
    }

    final EntrySupportLazyState changeMustNotify(boolean bl) {
        return new EntrySupportLazyState(this.inited, this.initThread, this.initInProgress, bl, this.entries, this.visibleEntries, this.entryToInfo);
    }

    final EntrySupportLazyState changeEntries(List<Children.Entry> list, List<Children.Entry> list2, Map<Children.Entry, EntryInfo> map) {
        if (list == null) {
            list = this.entries;
        }
        if (list2 == null) {
            list2 = this.visibleEntries;
        }
        if (map == null) {
            map = this.entryToInfo;
        }
        EntrySupportLazyState entrySupportLazyState = new EntrySupportLazyState(this.inited, this.initThread, this.initInProgress, this.mustNotifySetEntries, list, list2, map);
        int n = 0;
        int n2 = 0;
        assert ((n = entrySupportLazyState.getEntries().size()) >= 0);
        assert ((n2 = entrySupportLazyState.getEntryToInfo().size()) >= 0);
        assert (entrySupportLazyState.getEntries().size() == entrySupportLazyState.getEntryToInfo().size()) : "Entries: " + entrySupportLazyState.getEntries().size() + "; vis. entries: " + EntrySupportLazy.notNull(entrySupportLazyState.getVisibleEntries()).size() + "; Infos: " + entrySupportLazyState.getEntryToInfo().size() + "; entriesSize: " + n + "; entryToInfoSize: " + n2 + EntrySupportLazy.dumpEntriesInfos(entrySupportLazyState.getEntries(), entrySupportLazyState.getEntryToInfo());
        return entrySupportLazyState;
    }

    public String toString() {
        int n = this.getEntries().size();
        int n2 = this.getEntryToInfo().size();
        return "Inited: " + this.inited + "\nThread: " + this.initThread + "\nInProgress: " + this.initInProgress + "\nMustNotify: " + this.mustNotifySetEntries + "\nEntries: " + this.getEntries().size() + "; vis. entries: " + EntrySupportLazy.notNull(this.getVisibleEntries()).size() + "; Infos: " + this.getEntryToInfo().size() + "; entriesSize: " + n + "; entryToInfoSize: " + n2 + EntrySupportLazy.dumpEntriesInfos(this.getEntries(), this.getEntryToInfo());
    }

    private static final class NodeRef
    extends WeakReference<Node>
    implements Runnable {
        private final EntryInfo info;

        public NodeRef(Node node, EntryInfo entryInfo) {
            super(node, Utilities.activeReferenceQueue());
            entryInfo.lazy().registerNode(1, entryInfo);
            this.info = entryInfo;
        }

        @Override
        public void run() {
            this.info.lazy().registerNode(-1, this.info);
        }
    }

    static final class EntryInfo {
        private final EntrySupportLazy lazy;
        private final Children.Entry entry;
        private final int index;
        private NodeRef refNode;
        Thread creatingNodeThread;

        public EntryInfo(EntrySupportLazy entrySupportLazy, Children.Entry entry) {
            this(entrySupportLazy, entry, -1, (NodeRef)null);
        }

        private EntryInfo(EntrySupportLazy entrySupportLazy, Children.Entry entry, int n, NodeRef nodeRef) {
            this.lazy = entrySupportLazy;
            this.entry = entry;
            this.index = n;
            this.refNode = nodeRef;
        }

        private EntryInfo(EntrySupportLazy entrySupportLazy, Children.Entry entry, int n, Node node) {
            this.lazy = entrySupportLazy;
            this.entry = entry;
            this.index = n;
            this.refNode = new NodeRef(node, this);
        }

        final EntryInfo changeNode(Node node) {
            if (node != null) {
                return new EntryInfo(this.lazy, this.entry, this.index, node);
            }
            return new EntryInfo(this.lazy, this.entry, this.index, this.refNode);
        }

        final EntryInfo changeIndex(int n) {
            return new EntryInfo(this.lazy, this.entry, n, this.refNode);
        }

        final EntrySupportLazy lazy() {
            return this.lazy;
        }

        final Children.Entry entry() {
            return this.entry;
        }

        private Object lock() {
            return this.lazy.LOCK;
        }

        public final Node getNode() {
            return this.getNode(false, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Node getNode(boolean bl, Object object) {
            Object object2;
            Node node;
            while (true) {
                boolean bl2 = false;
                Collection<Object> collection = this.lock();
                synchronized (collection) {
                    if (bl) {
                        this.refNode = null;
                    }
                    if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                        return node;
                    }
                    if (this.creatingNodeThread != null) {
                        if (this.creatingNodeThread == Thread.currentThread()) {
                            return new EntrySupportLazy.DummyNode();
                        }
                        try {
                            this.lock().wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        this.creatingNodeThread = Thread.currentThread();
                        bl2 = true;
                    }
                }
                collection = Collections.emptyList();
                try {
                    if (bl2) {
                        try {
                            collection = this.entry.nodes(object);
                        }
                        catch (RuntimeException runtimeException) {
                            NodeOp.warning(runtimeException);
                        }
                    }
                    object2 = this.lock();
                }
                catch (Throwable throwable) {
                    Object object3 = this.lock();
                    synchronized (object3) {
                        if (!bl2) {
                            if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                                return node;
                            }
                            // MONITOREXIT @DISABLED, blocks:[5, 21, 8, 13, 15] lbl67 : MonitorExitStatement: MONITOREXIT : var10_10
                            continue;
                        }
                        if (collection.isEmpty()) {
                            node = new EntrySupportLazy.DummyNode();
                        } else {
                            if (collection.size() > 1) {
                                EntrySupportLazy.LOGGER.log(Level.FINE, "Number of nodes for Entry: {0} is {1} instead of 1", new Object[]{this.entry, collection.size()});
                            }
                            node = (Node)collection.iterator().next();
                        }
                        this.refNode = new NodeRef(node, this);
                        if (bl2) {
                            this.creatingNodeThread = null;
                            this.lock().notifyAll();
                        }
                    }
                    throw throwable;
                }
                synchronized (object2) {
                    if (!bl2) {
                        if (this.refNode != null && (node = (Node)this.refNode.get()) != null) {
                            return node;
                        }
                        continue;
                    }
                    if (collection.isEmpty()) {
                        node = new EntrySupportLazy.DummyNode();
                    } else {
                        if (collection.size() > 1) {
                            EntrySupportLazy.LOGGER.log(Level.FINE, "Number of nodes for Entry: {0} is {1} instead of 1", new Object[]{this.entry, collection.size()});
                        }
                        node = (Node)collection.iterator().next();
                    }
                    this.refNode = new NodeRef(node, this);
                    if (bl2) {
                        this.creatingNodeThread = null;
                        this.lock().notifyAll();
                    }
                }
                break;
            }
            object2 = this.lazy().children;
            node.assignTo((Children)object2, -1);
            node.fireParentNodeChange(null, ((Children)object2).parent);
            return node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Node currentNode() {
            Object object = this.lock();
            synchronized (object) {
                return this.refNode == null ? null : (Node)this.refNode.get();
            }
        }

        final boolean isHidden() {
            return this.index == -2;
        }

        final int getIndex() {
            assert (this.index >= 0) : "When first asked for it has to be set: " + this.index;
            return this.index;
        }

        public String toString() {
            return "EntryInfo for entry: " + this.entry + ", node: " + (this.refNode == null ? null : (Node)this.refNode.get());
        }
    }
}

