/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class HeapProgress {
    public static final int PROGRESS_MAX = 1000;
    private static ThreadLocal<ModelInfo> progressThreadLocal = new ThreadLocal();
    private static Map<Long, ModelInfo> progresses = Collections.synchronizedMap(new HashMap());

    private HeapProgress() {
    }

    public static long getProgressId() {
        ModelInfo info = progressThreadLocal.get();
        if (info == null) {
            info = new ModelInfo();
            progressThreadLocal.set(info);
            progresses.put(info.progressId, info);
        }
        return info.progressId;
    }

    public static int getProgressValue(long progressId) {
        ModelInfo info = progresses.get(progressId);
        if (info != null) {
            return info.value;
        }
        return -1;
    }

    static void progress(long counter, long startOffset, long value, long endOffset) {
        if (counter % 100000L == 0L) {
            HeapProgress.progress(value, endOffset, startOffset);
        }
    }

    static void progress(long value, long endValue) {
        HeapProgress.progress(value, 0L, value, endValue);
    }

    private static void progress(long value, long endOffset, long startOffset) {
        ModelInfo info = progressThreadLocal.get();
        if (info != null) {
            if (info.level > info.divider) {
                info.divider = info.level;
            }
            long val = 1000L * (value - startOffset) / (endOffset - startOffset);
            int modelVal = (int)((long)info.offset + val / (long)info.divider);
            info.value = modelVal;
        }
    }

    private static int levelAdd(ModelInfo info, int diff) {
        ModelInfo modelInfo = info;
        modelInfo.level = modelInfo.level + diff;
        return info.level;
    }

    static void progressStart() {
        ModelInfo info = progressThreadLocal.get();
        if (info != null) {
            HeapProgress.levelAdd(info, 1);
        }
    }

    static void progressFinish() {
        ModelInfo info = progressThreadLocal.get();
        if (info != null) {
            int level = HeapProgress.levelAdd(info, -1);
            assert (level >= 0);
            if (level == 0) {
                progressThreadLocal.remove();
                progresses.remove(info.progressId);
            }
            info.offset = info.value;
        }
    }

    private static class ModelInfo {
        private static final AtomicLong PROGRESS_ID = new AtomicLong(0L);
        private final long progressId = PROGRESS_ID.incrementAndGet();
        private int level;
        private int divider;
        private int offset;
        private int value;

        private ModelInfo() {
        }
    }
}

