/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.impl.MultiRowTabDisplayer;
import org.netbeans.core.multitabs.impl.RowPerProjectTabDisplayer;
import org.netbeans.core.multitabs.impl.SimpleTabDisplayer;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.openide.util.Lookup;

public abstract class TabDisplayerFactory {
    public static TabDisplayerFactory getDefault() {
        TabDisplayerFactory tabDisplayerFactory = (TabDisplayerFactory)Lookup.getDefault().lookup(TabDisplayerFactory.class);
        if (null == tabDisplayerFactory) {
            tabDisplayerFactory = new DefaultTabDisplayerFactory();
        }
        return tabDisplayerFactory;
    }

    public abstract TabDisplayer createTabDisplayer(TabDataModel var1, int var2);

    private static class DefaultTabDisplayerFactory
    extends TabDisplayerFactory {
        private DefaultTabDisplayerFactory() {
        }

        @Override
        public TabDisplayer createTabDisplayer(TabDataModel tabDataModel, int n) {
            boolean bl;
            Settings settings = Settings.getDefault();
            boolean bl2 = bl = settings.getRowCount() > 1 || settings.isTabRowPerProject();
            if (bl && (n == 1 || n == 3)) {
                if (settings.isTabRowPerProject()) {
                    return new RowPerProjectTabDisplayer(tabDataModel, n);
                }
                return new MultiRowTabDisplayer(tabDataModel, n);
            }
            return new SimpleTabDisplayer(tabDataModel, n);
        }
    }
}

