<div align="center">
  <h1><code>wasip2</code></h1>

<strong>A <a href="https://bytecodealliance.org/">Bytecode Alliance</a> project</strong>

  <p>
    <strong>WASIp2 API Bindings for Rust</strong>
  </p>

  <p>
    <a href="https://crates.io/crates/wasip2"><img src="https://img.shields.io/crates/v/wasip2.svg?style=flat-square" alt="Crates.io version" /></a>
    <a href="https://crates.io/crates/wasip2"><img src="https://img.shields.io/crates/d/wasip2.svg?style=flat-square" alt="Download" /></a>
    <a href="https://docs.rs/wasip2/"><img src="https://img.shields.io/badge/docs-latest-blue.svg?style=flat-square" alt="docs.rs docs" /></a>
  </p>
</div>

This crate contains bindings for [WASIp2](https://github.com/WebAssembly/WASI)
APIs for the worlds:

* [`wasi:cli/command`]
* [`wasi:http/proxy`]

This crate is procedurally generated from [WIT] files using [`wit-bindgen`].

[`wasi:cli/command`]: https://github.com/WebAssembly/wasi-cli
[`wasi:http/proxy`]: https://github.com/WebAssembly/wasi-http
[WIT]: https://component-model.bytecodealliance.org/design/wit.html
[`wit-bindgen`]: https://github.com/bytecodealliance/wit-bindgen
[components]: https://component-model.bytecodealliance.org/
[`wasm-tools`]: https://github.com/bytecodealliance/wasm-tools

# Usage

Depending on this crate can be done by adding it to your dependencies:

```sh
$ cargo add wasip2
```

Next you can use the APIs in the root of the module like so:

```rust
fn main() {
    let stdout = wasip2::cli::stdout::get_stdout();
    stdout.blocking_write_and_flush(b"Hello, world!\n").unwrap();
}
```

This crate can currently be used in three main ways.

- One is to use it and compile for the [`wasm32-wasip2` target] in Rust 1.82 and later.
  this is the simplest approach, as all the tools needed are included in the
  Rust tooling, however it doesn't yet support some of the features of the
  other approaches.

- Another is to use it and compile using [`cargo component`]. This is essentially
  the same as the next option, except that `cargo component` handles most of the
  steps for you. `cargo component` also has a number of additional features for
  working with dependencies and custom WIT interfaces.

- And the third is to compile for the `wasm32-wasip1` target, and then adapt
  the resulting modules into component using `wasm-tools component new`; see
  the next section here for details.

[`wasm32-wasip2` target]: https://blog.rust-lang.org/2024/11/26/wasip2-tier-2.html
[`cargo component`]: https://github.com/bytecodealliance/cargo-component

## Building with wasm32-wasip1 and `cargo component new`.

The `wasm32-wasip2` target works with a simple `cargo build --target wasm32-wasip2`
and doesn't need a lot of documentation here, and `cargo component` has its own
documentation, so here we have some documentation for the `wasm32-wasip1` way.

```
$ cargo build --target wasm32-wasip1
```

Next you'll want an "adapter" to convert the Rust standard library's usage of
`wasi_snapshot_preview1` to the component model. An example adapter can be found
from [Wasmtime's release page](https://github.com/bytecodealliance/wasmtime/releases/download/v17.0.0/wasi_snapshot_preview1.command.wasm).

```
$ curl -LO https://github.com/bytecodealliance/wasmtime/releases/download/v17.0.0/wasi_snapshot_preview1.command.wasm
```

Next to create a component you'll use the [`wasm-tools`] CLI to create a
component:

```
$ cargo install wasm-tools
$ wasm-tools component new target/wasm32-wasip1/debug/foo.wasm \
    --adapt ./wasi_snapshot_preview1.command.wasm \
    -o component.wasm
```

And finally the component can be run by a runtime that has Component Model
support, such as [Wasmtime]:

```
$ wasmtime run component.wasm
Hello, world!
```

[Wasmtime]: https://github.com/bytecodealliance/wasmtime

# Development

The bulk of the `wasip2` crate is generated by the [`wit-bindgen`] tool. The
`src/bindings.rs` file can be regenerated with:

```
$ ./ci/regenerate.sh
```

WASI definitions are located in the `wit` directory of this repository.
Currently they're copied from upstream repositories but are hoped to be better
managed in the future.
