/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 0ul) => i64vec3(-1333333333333333259l, 85l, 94l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 1ul) => i64vec3(-666666666666666630l, 42l, 47l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 2ul) => i64vec3(-333333333333333315l, 21l, 23l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 5ul) => i64vec3(-41666666666666665l, 2l, 2l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 25ul) => i64vec3(-39736429851l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 31ul) => i64vec3(-620881717l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 32ul) => i64vec3(-310440859l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 47ul) => i64vec3(-9474l, 0l, 0l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) >> 63ul) => i64vec3(-1l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) >> 0ul) => i64vec3(167l, 66l, 187l)
 * (i64vec3(167l, 66l, 187l) >> 1ul) => i64vec3(83l, 33l, 93l)
 * (i64vec3(167l, 66l, 187l) >> 2ul) => i64vec3(41l, 16l, 46l)
 * (i64vec3(167l, 66l, 187l) >> 5ul) => i64vec3(5l, 2l, 5l)
 * (i64vec3(167l, 66l, 187l) >> 25ul) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) >> 31ul) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) >> 32ul) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) >> 47ul) => i64vec3(0l, 0l, 0l)
 * (i64vec3(167l, 66l, 187l) >> 63ul) => i64vec3(0l, 0l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 0ul), i64vec3(-1333333333333333259l, 85l, 94l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 1ul), i64vec3(-666666666666666630l, 42l, 47l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 2ul), i64vec3(-333333333333333315l, 21l, 23l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 5ul), i64vec3(-41666666666666665l, 2l, 2l))) ? 1 : -1] array3;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 25ul), i64vec3(-39736429851l, 0l, 0l))) ? 1 : -1] array4;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 31ul), i64vec3(-620881717l, 0l, 0l))) ? 1 : -1] array5;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 32ul), i64vec3(-310440859l, 0l, 0l))) ? 1 : -1] array6;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 47ul), i64vec3(-9474l, 0l, 0l))) ? 1 : -1] array7;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) >> 63ul), i64vec3(-1l, 0l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 0ul), i64vec3(167l, 66l, 187l))) ? 1 : -1] array9;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 1ul), i64vec3(83l, 33l, 93l))) ? 1 : -1] array10;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 2ul), i64vec3(41l, 16l, 46l))) ? 1 : -1] array11;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 5ul), i64vec3(5l, 2l, 5l))) ? 1 : -1] array12;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 25ul), i64vec3(0l, 0l, 0l))) ? 1 : -1] array13;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 31ul), i64vec3(0l, 0l, 0l))) ? 1 : -1] array14;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 32ul), i64vec3(0l, 0l, 0l))) ? 1 : -1] array15;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 47ul), i64vec3(0l, 0l, 0l))) ? 1 : -1] array16;
  float[all(equal((i64vec3(167l, 66l, 187l) >> 63ul), i64vec3(0l, 0l, 0l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
