/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.syncope;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.json.JSONParser;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncopeBackingEngine
implements BackingEngine {
    private final Logger logger = LoggerFactory.getLogger(SyncopeBackingEngine.class);
    private String address;
    private boolean version2;
    private DefaultHttpClient client;

    public SyncopeBackingEngine(String address, String version, String adminUser, String adminPassword) {
        this.address = address;
        this.version2 = version != null && (version.equals("2.x") || version.equals("2"));
        this.client = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(adminUser, adminPassword);
        this.client.getCredentialsProvider().setCredentials(AuthScope.ANY, creds);
    }

    @Override
    public void addUser(String username, String password) {
        if (username.startsWith("_g_:")) {
            throw new IllegalArgumentException("Group prefix _g_: not permitted with Syncope backend");
        }
        if (this.version2) {
            this.addUserSyncope2(username, password);
        } else {
            this.addUserSyncope1(username, password);
        }
    }

    private void addUserSyncope1(String username, String password) {
        HttpPost request = new HttpPost(this.address + "/users");
        request.setHeader("Content-Type", "application/xml");
        String userTO = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><user><attributes><attribute><readonly>false</readonly><schema>fullname</schema><value>" + username + "</value></attribute><attribute><readonly>false</readonly><schema>surname</schema><value>" + username + "</value></attribute><attribute><readonly>false</readonly><schema>userId</schema><value>" + username + "@karaf.apache.org</value></attribute></attributes><password>" + password + "</password><username>" + username + "</username></user>";
        try {
            StringEntity entity = new StringEntity(userTO);
            request.setEntity(entity);
            CloseableHttpResponse closeableHttpResponse = this.client.execute(request);
        }
        catch (Exception e) {
            this.logger.error("Can't add user {}", (Object)username, (Object)e);
            throw new RuntimeException("Can't add user " + username, e);
        }
    }

    private void addUserSyncope2(String username, String password) {
        HttpPost request = new HttpPost(this.address + "/users");
        request.setHeader("Content-Type", "application/json");
        String userTO = "{\"@class\": \"org.apache.syncope.common.lib.to.UserTO\",\"type\": \"USER\",\"realm\": \"/\",\"username\": \"" + username + "\",\"password\": \"" + password + "\",\"plainAttrs\": [{ \"schema\": \"surname\", \"values\": [\"" + username + "\"] },{ \"schema\": \"fullname\", \"values\": [\"" + username + "\"] },{ \"schema\": \"userId\", \"value\": [\"" + username + "@karaf.apache.org\"] }}";
        try {
            StringEntity entity = new StringEntity(userTO);
            request.setEntity(entity);
            CloseableHttpResponse closeableHttpResponse = this.client.execute(request);
        }
        catch (Exception e) {
            this.logger.error("Can't add user {}", (Object)username, (Object)e);
            throw new RuntimeException("Can't add user " + username, e);
        }
    }

    @Override
    public void deleteUser(String username) {
        if (username.startsWith("_g_:")) {
            throw new IllegalArgumentException("Group prefix _g_: not permitted with Syncope backend");
        }
        HttpDelete request = new HttpDelete(this.address + "/users/" + username);
        if (this.version2) {
            request.setHeader("Content-Type", "application/json");
        } else {
            request.setHeader("Content-Type", "application/xml");
        }
        try {
            this.client.execute(request);
        }
        catch (Exception e) {
            this.logger.error("Can't delete user {}", (Object)username, (Object)e);
            throw new RuntimeException("Can't delete user " + username, e);
        }
    }

    @Override
    public List<UserPrincipal> listUsers() {
        if (this.version2) {
            return this.listUsersSyncope2();
        }
        return this.listUsersSyncope1();
    }

    private List<UserPrincipal> listUsersSyncope1() {
        ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
        HttpGet request = new HttpGet(this.address + "/users");
        request.setHeader("Content-Type", "application/xml");
        try {
            CloseableHttpResponse response = this.client.execute(request);
            String responseTO = EntityUtils.toString(response.getEntity());
            if (responseTO != null && !responseTO.isEmpty()) {
                int index = responseTO.indexOf("<username>");
                while (index != -1) {
                    int end = (responseTO = responseTO.substring(index + "<username>".length())).indexOf("</username>");
                    if (end == -1) {
                        index = -1;
                    }
                    String username = responseTO.substring(0, end);
                    users.add(new UserPrincipal(username));
                    responseTO = responseTO.substring(end + "</username>".length());
                    index = responseTO.indexOf("<username>");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing users", e);
        }
        return users;
    }

    private List<UserPrincipal> listUsersSyncope2() {
        ArrayList<UserPrincipal> users = new ArrayList<UserPrincipal>();
        HttpGet request = new HttpGet(this.address + "/users");
        request.setHeader("Content-Type", "application/json");
        try {
            CloseableHttpResponse httpResponse = this.client.execute(request);
            String response = EntityUtils.toString(httpResponse.getEntity());
            JSONParser parser = new JSONParser(response);
            List results = (List)parser.getParsed().get("result");
            for (Map result : results) {
                users.add(new UserPrincipal((String)result.get("username")));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing users", e);
        }
        return users;
    }

    @Override
    public UserPrincipal lookupUser(String username) {
        if (this.version2) {
            return this.lookupUserSyncope2(username);
        }
        return this.lookupUserSyncope1(username);
    }

    private UserPrincipal lookupUserSyncope1(String username) {
        HttpGet request = new HttpGet(this.address + "/users?username=" + username);
        request.setHeader("Content-Type", "application/xml");
        try {
            CloseableHttpResponse response = this.client.execute(request);
            String responseTO = EntityUtils.toString(response.getEntity());
            if (responseTO != null && !responseTO.isEmpty()) {
                return new UserPrincipal(username);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting user", e);
        }
        return null;
    }

    private UserPrincipal lookupUserSyncope2(String username) {
        HttpGet request = new HttpGet(this.address + "/users/" + username);
        request.setHeader("Content-Type", "application/json");
        try {
            CloseableHttpResponse httpResponse = this.client.execute(request);
            String response = EntityUtils.toString(httpResponse.getEntity());
            if (response != null && !response.isEmpty()) {
                return new UserPrincipal(username);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting user", e);
        }
        return null;
    }

    @Override
    public List<RolePrincipal> listRoles(Principal principal) {
        if (this.version2) {
            return this.listRolesSyncope2(principal);
        }
        return this.listRolesSyncope1(principal);
    }

    private List<RolePrincipal> listRolesSyncope1(Principal principal) {
        ArrayList<RolePrincipal> roles;
        block4: {
            roles = new ArrayList<RolePrincipal>();
            HttpGet request = new HttpGet(this.address + "/users?username=" + principal.getName());
            request.setHeader("Content-Type", "application/xml");
            try {
                CloseableHttpResponse response = this.client.execute(request);
                String responseTO = EntityUtils.toString(response.getEntity());
                if (responseTO == null || responseTO.isEmpty()) break block4;
                int index = responseTO.indexOf("<roleName>");
                while (index != 1) {
                    int end = (responseTO = responseTO.substring(index + "<roleName>".length())).indexOf("</roleName>");
                    if (end == -1) {
                        index = -1;
                        break;
                    }
                    String role = responseTO.substring(0, end);
                    roles.add(new RolePrincipal(role));
                    responseTO = responseTO.substring(end + "</roleName>".length());
                    index = responseTO.indexOf("<roleName>");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error listing roles", e);
            }
        }
        return roles;
    }

    private List<RolePrincipal> listRolesSyncope2(Principal principal) {
        ArrayList<RolePrincipal> result = new ArrayList<RolePrincipal>();
        HttpGet request = new HttpGet(this.address + "/users/" + principal.getName());
        request.setHeader("Content-Type", "application/json");
        try {
            CloseableHttpResponse httpResponse = this.client.execute(request);
            String response = EntityUtils.toString(httpResponse.getEntity());
            if (response != null && !response.isEmpty()) {
                JSONParser parser = new JSONParser(response);
                List roles = (List)parser.getParsed().get("roles");
                for (String role : roles) {
                    result.add(new RolePrincipal(role));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error listing roles", e);
        }
        return result;
    }

    @Override
    public void addRole(String username, String role) {
        throw new RuntimeException("Roles management should be done on the Syncope side");
    }

    @Override
    public void deleteRole(String username, String role) {
        throw new RuntimeException("Roles management should be done on the Syncope side");
    }

    @Override
    public List<GroupPrincipal> listGroups(UserPrincipal principal) {
        return new ArrayList<GroupPrincipal>();
    }

    @Override
    public void addGroup(String username, String group) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void deleteGroup(String username, String group) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void addGroupRole(String group, String role) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void deleteGroupRole(String group, String role) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public Map<GroupPrincipal, String> listGroups() {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }

    @Override
    public void createGroup(String group) {
        throw new RuntimeException("Group management is not supported by Syncope backend");
    }
}

