/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.util.ByteArrays;

public final class UnknownIpV6RoutingData
implements IpV6ExtRoutingPacket.IpV6RoutingData {
    private static final long serialVersionUID = -6359533865311266265L;
    private final byte[] rawData;

    public static UnknownIpV6RoutingData newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UnknownIpV6RoutingData(rawData, offset, length);
    }

    private UnknownIpV6RoutingData(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if ((length + 4) % 8 != 0) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("(length + 4) % 8 must be 0. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, this.rawData.length);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[data: ").append(ByteArrays.toHexString(this.rawData, " ")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        UnknownIpV6RoutingData other = (UnknownIpV6RoutingData)obj;
        return Arrays.equals(this.rawData, other.rawData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawData);
    }
}

