/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks;

import com.almworks.tracker.eapi.alpha.ArtifactInfo;
import com.almworks.tracker.eapi.alpha.GenericKeys;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.psi.PsiFile;
import com.intellij.usages.TextChunk;
import java.awt.Color;

public class VCSLink {
    private final ArtifactInfo myArtifactInfo;
    private final PsiFile myFile;
    private final VcsFileRevision myOldRevision;
    private final VcsFileRevision myNewRevision;

    public VCSLink(ArtifactInfo artifactInfo, PsiFile file, VcsFileRevision oldRevision, VcsFileRevision newRevision) {
        this.myArtifactInfo = artifactInfo;
        this.myFile = file;
        this.myOldRevision = oldRevision;
        this.myNewRevision = newRevision;
    }

    public ArtifactInfo getArtifactInfo() {
        return this.myArtifactInfo;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public VcsFileRevision getOldRevision() {
        return this.myOldRevision;
    }

    public VcsFileRevision getNewRevision() {
        return this.myNewRevision;
    }

    public TextChunk[] getText() {
        return new TextChunk[]{new TextChunk(new TextAttributes(Color.DARK_GRAY, Color.WHITE, null, null, 1), this.myOldRevision != null ? this.myOldRevision.getRevisionNumber().asString() : ""), new TextChunk(new TextAttributes(Color.BLACK, Color.YELLOW.brighter(), Color.WHITE, null, 1), "-->"), new TextChunk(new TextAttributes(Color.DARK_GRAY, Color.WHITE, null, null, 1), this.myNewRevision != null ? this.myNewRevision.getRevisionNumber().asString() : ""), new TextChunk(new TextAttributes(), " "), new TextChunk(new TextAttributes(Color.PINK.darker(), Color.WHITE.brighter(), null, null, 1), (String)this.myArtifactInfo.getPresentation(GenericKeys.ID))};
    }

    public String toString() {
        TextChunk[] text;
        StringBuffer sb = new StringBuffer();
        for (TextChunk aText : text = this.getText()) {
            sb.append(aText);
        }
        return sb.toString();
    }
}

