/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestData;
import org.apache.kafka.common.message.AlterUserScramCredentialsRequestDataJsonConverter;
import org.apache.kafka.common.message.AlterUserScramCredentialsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterUserScramCredentialsResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterUserScramCredentialsRequest
extends AbstractRequest {
    private final AlterUserScramCredentialsRequestData data;

    private AlterUserScramCredentialsRequest(AlterUserScramCredentialsRequestData data, short version) {
        super(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS, version);
        this.data = data;
    }

    public static AlterUserScramCredentialsRequest parse(Readable readable, short version) {
        return new AlterUserScramCredentialsRequest(new AlterUserScramCredentialsRequestData(readable, version), version);
    }

    @Override
    public AlterUserScramCredentialsRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        short errorCode = apiError.error().code();
        String errorMessage = apiError.message();
        Set users = Stream.concat(this.data.deletions().stream().map(deletion -> deletion.name()), this.data.upsertions().stream().map(upsertion -> upsertion.name())).collect(Collectors.toSet());
        List<AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult> results = users.stream().sorted().map(user -> new AlterUserScramCredentialsResponseData.AlterUserScramCredentialsResult().setUser((String)user).setErrorCode(errorCode).setErrorMessage(errorMessage)).collect(Collectors.toList());
        return new AlterUserScramCredentialsResponse(new AlterUserScramCredentialsResponseData().setResults(results));
    }

    @Override
    public String toString() {
        JsonNode json = AlterUserScramCredentialsRequestDataJsonConverter.write(this.data, this.version()).deepCopy();
        for (JsonNode upsertion : json.get("upsertions")) {
            ((ObjectNode)upsertion).put("salt", "");
            ((ObjectNode)upsertion).put("saltedPassword", "");
        }
        return AlterUserScramCredentialsRequestDataJsonConverter.read(json, this.version()).toString();
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterUserScramCredentialsRequest> {
        private final AlterUserScramCredentialsRequestData data;

        public Builder(AlterUserScramCredentialsRequestData data) {
            super(ApiKeys.ALTER_USER_SCRAM_CREDENTIALS);
            this.data = data;
        }

        @Override
        public AlterUserScramCredentialsRequest build(short version) {
            return new AlterUserScramCredentialsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

