/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.Command;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;

public class MergeCellsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "mergeCells";
    private String cols;
    private String rows;
    private String minCols;
    private String minRows;
    private Area area;

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String getCols() {
        return this.cols;
    }

    public void setCols(String cols) {
        this.cols = cols;
    }

    public String getRows() {
        return this.rows;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public String getMinCols() {
        return this.minCols;
    }

    public void setMinCols(String minCols) {
        this.minCols = minCols;
    }

    public String getMinRows() {
        return this.minRows;
    }

    public void setMinRows(String minRows) {
        this.minRows = minRows;
    }

    @Override
    public Command addArea(Area area) {
        if (super.getAreaList().size() >= 1) {
            throw new IllegalArgumentException("You can only add 1 area to 'mergeCells' command!");
        }
        this.area = area;
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        int rows = this.getVal(this.rows, context);
        int cols = this.getVal(this.cols, context);
        rows = Math.max(this.getVal(this.minRows, context), rows);
        cols = Math.max(this.getVal(this.minCols, context), cols);
        rows = rows > 0 ? rows : this.area.getSize().getHeight();
        int n = cols = cols > 0 ? cols : this.area.getSize().getWidth();
        if (rows > 1 || cols > 1) {
            this.getTransformer().mergeCells(cellRef, rows, cols);
        }
        this.area.applyAt(cellRef, context);
        return new Size(cols, rows);
    }

    private int getVal(String expression, Context context) {
        if (expression != null && expression.trim().length() > 0) {
            Object obj = this.getTransformationConfig().getExpressionEvaluator().evaluate(expression, context.toMap());
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Expression: " + expression + " failed to resolve");
            }
        }
        return 0;
    }
}

