/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.actions;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.openide.util.RequestProcessor;

public abstract class FlashingIcon
extends JComponent
implements MouseListener {
    protected int STOP_FLASHING_DELAY = 10000;
    protected int DISAPPEAR_DELAY_MILLIS = this.STOP_FLASHING_DELAY + 50000;
    protected int FLASHING_FREQUENCY = 500;
    private Icon icon;
    private boolean keepRunning = false;
    private boolean isIconVisible = false;
    private boolean keepFlashing = true;
    private long startTime = 0L;
    private RequestProcessor.Task timerTask;

    protected FlashingIcon(Icon icon) {
        this.icon = icon;
        Dimension dimension = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.setVisible(false);
        this.addMouseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startFlashing() {
        FlashingIcon flashingIcon = this;
        synchronized (flashingIcon) {
            this.startTime = System.currentTimeMillis();
            this.isIconVisible = !this.isIconVisible;
            this.keepRunning = true;
            this.keepFlashing = true;
            if (null == this.timerTask) {
                this.timerTask = RequestProcessor.getDefault().post((Runnable)new Timer());
            } else {
                this.timerTask.run();
            }
            this.setVisible(true);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disappear() {
        FlashingIcon flashingIcon = this;
        synchronized (flashingIcon) {
            this.keepRunning = false;
            this.isIconVisible = false;
            this.keepFlashing = false;
            if (null != this.timerTask) {
                this.timerTask.cancel();
            }
            this.timerTask = null;
            this.setToolTipText(null);
            this.setVisible(false);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFlashing() {
        FlashingIcon flashingIcon = this;
        synchronized (flashingIcon) {
            if (this.keepRunning && !this.isIconVisible) {
                this.isIconVisible = true;
                this.repaint();
            }
        }
        this.keepFlashing = false;
    }

    protected void flashIcon() {
        this.isIconVisible = !this.isIconVisible;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.isIconVisible) {
            this.icon.paintIcon(this, graphics, 0, 0);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.stopFlashing();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.stopFlashing();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.stopFlashing();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isIconVisible) {
            this.onMouseClick();
        }
    }

    protected abstract void onMouseClick();

    protected abstract void timeout();

    public Cursor getCursor() {
        if (this.isIconVisible) {
            return Cursor.getPredefinedCursor(12);
        }
        return Cursor.getDefaultCursor();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        JToolTip jToolTip = this.createToolTip();
        jToolTip.setTipText(this.getToolTipText());
        Dimension dimension = jToolTip.getPreferredSize();
        Point point = new Point(this.getWidth() - dimension.width, -dimension.height);
        return point;
    }

    private class Timer
    implements Runnable {
        private Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FlashingIcon flashingIcon = FlashingIcon.this;
            synchronized (flashingIcon) {
                long l = System.currentTimeMillis();
                if (FlashingIcon.this.keepFlashing) {
                    if (l - FlashingIcon.this.startTime < (long)FlashingIcon.this.STOP_FLASHING_DELAY) {
                        FlashingIcon.this.flashIcon();
                    } else {
                        FlashingIcon.this.stopFlashing();
                        if (FlashingIcon.this.DISAPPEAR_DELAY_MILLIS == -1) {
                            FlashingIcon.this.timerTask = null;
                        }
                    }
                }
                if (FlashingIcon.this.DISAPPEAR_DELAY_MILLIS > 0 && l - FlashingIcon.this.startTime >= (long)FlashingIcon.this.DISAPPEAR_DELAY_MILLIS) {
                    FlashingIcon.this.disappear();
                    FlashingIcon.this.timeout();
                } else if (null != FlashingIcon.this.timerTask) {
                    FlashingIcon.this.timerTask.schedule(FlashingIcon.this.FLASHING_FREQUENCY);
                }
            }
        }
    }
}

