/*
 * Decompiled with CFR 0.152.
 */
package au.com.trgtd.tr.report.sa;

import au.com.trgtd.tr.report.sa.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.view.JasperViewer;
import tr.extract.Extract;
import tr.extract.ExtractSingleActions;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamContext;
import tr.extract.ParamList;
import tr.extract.ParamTopic;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    private ParamList paramSort;
    private ParamList paramDone;
    private ParamTopic paramTopic;
    private ParamContext paramContext;
    private ParamBoolean paramThought;
    private ParamBoolean paramSuccess;
    private ParamBoolean paramCriteria;
    private ParamBoolean paramNotes;

    public String getID() {
        return "au.com.trgtd.tr.report.sa";
    }

    public String getName() {
        return this.getString("CTL_ReportAction");
    }

    public List<Param> getParams() {
        this.paramContext = new ParamContext("paramContext", this.getString("param-context"), Extract.FormatType.XML);
        this.paramTopic = new ParamTopic("paramTopic", this.getString("param-topic"), Extract.FormatType.XML);
        Vector<Param.Item> doneItems = new Vector<Param.Item>();
        doneItems.add(new Param.Item(this.getString("param-done-all"), "all"));
        doneItems.add(new Param.Item(this.getString("param-done-done"), "done"));
        doneItems.add(new Param.Item(this.getString("param-done-todo"), "todo"));
        this.paramDone = new ParamList("paramDone", this.getString("param-done"), doneItems);
        Vector<Param.Item> sortItems = new Vector<Param.Item>();
        sortItems.add(new Param.Item(this.getString("param-sort-none"), "none"));
        sortItems.add(new Param.Item(this.getString("param-sort-descr"), "descr"));
        sortItems.add(new Param.Item(this.getString("param-sort-priority"), "priority"));
        sortItems.add(new Param.Item(this.getString("param-sort-date"), "date"));
        this.paramSort = new ParamList("paramSort", this.getString("param-sort"), sortItems);
        this.paramThought = new ParamBoolean("paramThought", this.getString("param-thought"));
        this.paramCriteria = new ParamBoolean("paramCriteria", this.getString("param-criteria"));
        this.paramSuccess = new ParamBoolean("paramSuccess", this.getString("param-success"));
        this.paramNotes = new ParamBoolean("paramNotes", this.getString("param-notes"));
        Vector<Param> params = new Vector<Param>();
        params.add((Param)this.paramTopic);
        params.add((Param)this.paramContext);
        params.add((Param)this.paramDone);
        params.add((Param)this.paramThought);
        params.add((Param)this.paramSuccess);
        params.add((Param)this.paramCriteria);
        params.add((Param)this.paramNotes);
        params.add((Param)this.paramSort);
        return params;
    }

    public void process(Data data) throws Exception {
        String title = this.getDialogTitleReport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), this.getParams());
        if (dlg.showDialog() == 2) {
            return;
        }
        HashMap<String, Boolean> rparams = new HashMap<String, Boolean>();
        rparams.put("paramThought", Boolean.parseBoolean(this.paramThought.getValue()));
        rparams.put("paramSuccess", Boolean.parseBoolean(this.paramSuccess.getValue()));
        rparams.put("paramCriteria", Boolean.parseBoolean(this.paramCriteria.getValue()));
        rparams.put("paramNotes", Boolean.parseBoolean(this.paramNotes.getValue()));
        FileInputStream reportStream = null;
        if (this.paramSort.getValue().equals("none")) {
            reportStream = new FileInputStream(Resources.FILE_REPORT);
        } else if (this.paramSort.getValue().equals("descr")) {
            reportStream = new FileInputStream(Resources.FILE_REPORT_BY_DESCR);
        } else if (this.paramSort.getValue().equals("priority")) {
            reportStream = new FileInputStream(Resources.FILE_REPORT_BY_PRIORITY);
        } else if (this.paramSort.getValue().equals("date")) {
            reportStream = new FileInputStream(Resources.FILE_REPORT_BY_DATE);
        }
        File xmlfile = ReportImpl.getTmpFile((String)"SingleActions.xml");
        ExtractSingleActions.process((File)xmlfile, (Data)data, (String)this.paramTopic.getValue(), (String)this.paramContext.getValue(), (String)this.paramDone.getValue());
        JRXmlDataSource xmlDataSource = new JRXmlDataSource(xmlfile, "/data/action");
        JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)reportStream, rparams, (JRDataSource)xmlDataSource);
        JasperViewer.viewReport((JasperPrint)jasperPrint, (boolean)false);
    }
}

