/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;

public class JasperViewer
extends JFrame {
    private JRViewer viewer = null;
    private boolean isExitOnClose = true;
    private JPanel pnlMain;

    public JasperViewer(String sourceFile, boolean isXMLFile) throws JRException {
        this.isExitOnClose = true;
        this.initComponents();
        this.viewer = new JRViewer(sourceFile, isXMLFile);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(InputStream is, boolean isXMLFile) throws JRException {
        this.isExitOnClose = true;
        this.initComponents();
        this.viewer = new JRViewer(is, isXMLFile);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperPrint jasperPrint) {
        this.isExitOnClose = true;
        this.initComponents();
        this.viewer = new JRViewer(jasperPrint);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(sourceFile, isXMLFile);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(is, isXMLFile);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    public JasperViewer(JasperPrint jasperPrint, boolean isExitOnClose) {
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        this.viewer = new JRViewer(jasperPrint);
        this.pnlMain.add((Component)this.viewer, "Center");
    }

    private void initComponents() {
        int width;
        this.pnlMain = new JPanel();
        this.setTitle("JasperViewer");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/jricon.GIF")).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JasperViewer.this.exitForm();
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int screenResolution = toolkit.getScreenResolution();
        float zoom = (float)screenResolution / 72.0f;
        int height = (int)(550.0f * zoom);
        if ((double)height > screenSize.getHeight()) {
            height = (int)screenSize.getHeight();
        }
        if ((double)(width = (int)(750.0f * zoom)) > screenSize.getWidth()) {
            width = (int)screenSize.getWidth();
        }
        Dimension dimension = new Dimension(width, height);
        this.setSize(dimension);
        this.setLocation((screenSize.width - width) / 2, (screenSize.height - height) / 2);
    }

    void exitForm() {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.viewer.clear();
            this.viewer = null;
            this.getContentPane().removeAll();
            this.dispose();
        }
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            JasperViewer.usage();
            return;
        }
        for (int k = 0; args.length > k; ++k) {
            if (args[k].startsWith("-F")) {
                fileName = args[k].substring(2);
            }
            if (!args[k].startsWith("-XML")) continue;
            isXMLFile = true;
        }
        try {
            JasperViewer.viewReport(fileName, isXMLFile);
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperViewer usage:");
        System.out.println("\tjava JasperViewer -XML -Ffile");
    }

    public static void viewReport(String sourceFile, boolean isXMLFile) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(sourceFile, isXMLFile, true);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream is, boolean isXMLFile) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(is, isXMLFile, true);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint) {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, true);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(sourceFile, isXMLFile, isExitOnClose);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(is, isXMLFile, isExitOnClose);
        jasperViewer.setVisible(true);
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose) {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, isExitOnClose);
        jasperViewer.setVisible(true);
    }
}

