/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(0ul, 0ul, 0ul, 0ul)
 * (3ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(3ul, 3ul, 3ul, 3ul)
 * (1192ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(37ul, 128ul, 34ul, 52ul)
 * (1048576ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(1ul, 4ul, 7ul, 4ul)
 * (4251475ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(85ul, 130ul, 71ul, 35ul)
 * (29852643761ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(116ul, 17ul, 131ul, 17ul)
 * (4398046511104ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(4ul, 64ul, 3ul, 64ul)
 * (3948976685146ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(31ul, 87ul, 4ul, 30ul)
 * (135763469567146206ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(126ul, 30ul, 118ul, 30ul)
 * (11654173250180970009ul % u64vec4(165ul, 133ul, 193ul, 76ul)) => u64vec4(39ul, 130ul, 156ul, 73ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(0ul, 0ul, 0ul, 0ul))) ? 1 : -1] array0;
  float[all(equal((3ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(3ul, 3ul, 3ul, 3ul))) ? 1 : -1] array1;
  float[all(equal((1192ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(37ul, 128ul, 34ul, 52ul))) ? 1 : -1] array2;
  float[all(equal((1048576ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(1ul, 4ul, 7ul, 4ul))) ? 1 : -1] array3;
  float[all(equal((4251475ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(85ul, 130ul, 71ul, 35ul))) ? 1 : -1] array4;
  float[all(equal((29852643761ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(116ul, 17ul, 131ul, 17ul))) ? 1 : -1] array5;
  float[all(equal((4398046511104ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(4ul, 64ul, 3ul, 64ul))) ? 1 : -1] array6;
  float[all(equal((3948976685146ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(31ul, 87ul, 4ul, 30ul))) ? 1 : -1] array7;
  float[all(equal((135763469567146206ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(126ul, 30ul, 118ul, 30ul))) ? 1 : -1] array8;
  float[all(equal((11654173250180970009ul % u64vec4(165ul, 133ul, 193ul, 76ul)), u64vec4(39ul, 130ul, 156ul, 73ul))) ? 1 : -1] array9;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
