/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.rule.scoping;

import org.eclipse.xtext.common.types.access.impl.ClassFinder;
import org.eclipse.xtext.common.types.access.impl.ClassNameUtil;
import org.openhab.core.model.rule.scoping.RulesClassCache;

public class RulesClassFinder
extends ClassFinder {
    private static final Class<?> NULL_CLASS = Null.class;
    private final ClassLoader classLoader;
    private final ClassNameUtil classNameUtil = new ClassNameUtil();

    protected RulesClassFinder(ClassLoader classLoader) {
        super(classLoader);
        this.classLoader = classLoader;
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        RulesClassCache cache = RulesClassCache.getInstance();
        Class<?> result = (Class<?>)cache.get(name);
        if (result != null) {
            if (result == NULL_CLASS) {
                throw CACHED_EXCEPTION;
            }
            return result;
        }
        try {
            result = this.forName(this.classNameUtil.normalizeClassName(name), this.classLoader);
            cache.put(name, result);
            return result;
        }
        catch (ClassNotFoundException e) {
            cache.put(name, NULL_CLASS);
            throw e;
        }
    }

    protected Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, false, classLoader);
    }

    private static class Null {
        private Null() {
        }
    }
}

