/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.style.SAXONFunction;
import javax.xml.transform.TransformerException;

public class StyleSheetFunctionCall
extends Function {
    private SAXONFunction function;
    private Controller boundController = null;
    private NodeInfo boundContextNode = null;
    private int boundContextPosition = -1;
    private int boundContextSize = -1;

    public void setFunction(SAXONFunction sAXONFunction) {
        this.function = sAXONFunction;
    }

    public String getName() {
        return this.function.getAttribute("name");
    }

    public int getDataType() {
        return -1;
    }

    public Expression simplify() throws XPathException {
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            this.argument[n] = this.argument[n].simplify();
            ++n;
        }
        return this;
    }

    public int getDependencies() {
        int n = 0;
        if (this.boundController == null) {
            n |= 0x40;
        }
        if (this.boundContextNode == null) {
            n |= 8;
        }
        if (this.boundContextPosition == -1) {
            n |= 0x10;
        }
        if (this.boundContextSize == -1) {
            n |= 0x20;
        }
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            n |= this.argument[n2].getDependencies();
            ++n2;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        StyleSheetFunctionCall styleSheetFunctionCall = new StyleSheetFunctionCall();
        styleSheetFunctionCall.setFunction(this.function);
        styleSheetFunctionCall.setStaticContext(this.getStaticContext());
        styleSheetFunctionCall.boundController = this.boundController;
        styleSheetFunctionCall.boundContextNode = this.boundContextNode;
        styleSheetFunctionCall.boundContextPosition = this.boundContextPosition;
        styleSheetFunctionCall.boundContextSize = this.boundContextSize;
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            styleSheetFunctionCall.addArgument(this.argument[n2].reduce(n, context));
            ++n2;
        }
        if (this.boundController == null && (n & 0x40) != 0) {
            styleSheetFunctionCall.boundController = context.getController();
        }
        if (this.boundContextNode == null && (n & 8) != 0) {
            styleSheetFunctionCall.boundContextNode = context.getContextNodeInfo();
        }
        if (this.boundContextPosition == -1 && (n & 0x10) != 0) {
            styleSheetFunctionCall.boundContextPosition = context.getContextPosition();
        }
        if (this.boundContextSize == -1 && (n & 0x20) != 0) {
            styleSheetFunctionCall.boundContextSize = context.getLast();
        }
        return styleSheetFunctionCall.simplify();
    }

    public Value evaluate(Context context) throws XPathException {
        Context context2 = context.newContext();
        if (this.boundController != null) {
            context2.setController(this.boundController);
        }
        if (this.boundContextNode != null) {
            context2.setCurrentNode(this.boundContextNode);
            context2.setContextNode(this.boundContextNode);
        }
        if (this.boundContextPosition != -1) {
            context2.setPosition(this.boundContextPosition);
        }
        if (this.boundContextSize != -1) {
            context2.setLast(this.boundContextSize);
        }
        ParameterSet parameterSet = new ParameterSet();
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            int n2 = this.function.getNthParameter(n);
            if (n2 == -1) {
                throw new XPathException("Too many arguments");
            }
            parameterSet.put(n2, this.argument[n].evaluate(context));
            ++n;
        }
        try {
            return this.function.call(parameterSet, context2);
        }
        catch (TransformerException transformerException) {
            throw new XPathException(transformerException);
        }
    }
}

