/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import java.util.Set;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class ConfigClassBuildItem
extends MultiBuildItem {
    private final Class<?> configClass;
    private final Set<Class<?>> configComponentInterfaces;
    private final Set<Type> types;
    private final Set<String> generatedClasses;
    private final String prefix;
    private final Kind kind;
    private final DotName name;

    public ConfigClassBuildItem(Class<?> configClass, Set<Class<?>> configComponentInterfaces, Set<Type> types, Set<String> generatedClasses, String prefix, Kind kind) {
        this.configClass = configClass;
        this.configComponentInterfaces = configComponentInterfaces;
        this.types = types;
        this.generatedClasses = generatedClasses;
        this.prefix = prefix;
        this.kind = kind;
        this.name = DotName.createSimple((String)configClass.getName());
    }

    public Class<?> getConfigClass() {
        return this.configClass;
    }

    public Set<Class<?>> getConfigComponentInterfaces() {
        return this.configComponentInterfaces;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<String> getGeneratedClasses() {
        return this.generatedClasses;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Kind getKind() {
        return this.kind;
    }

    public DotName getName() {
        return this.name;
    }

    public boolean isMapping() {
        return Kind.MAPPING.equals((Object)this.kind);
    }

    public boolean isProperties() {
        return Kind.PROPERTIES.equals((Object)this.kind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigClassBuildItem that = (ConfigClassBuildItem)((Object)o);
        return this.configClass.equals(that.configClass) && this.prefix.equals(that.prefix) && this.kind == that.kind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configClass, this.prefix, this.kind});
    }

    public static enum Kind {
        MAPPING,
        PROPERTIES;

    }
}

