/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyEncoding;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.ThreadContext;

public class ArgumentDescriptor {
    public final ArgumentType type;
    public final RubySymbol name;
    public static final ArgumentDescriptor[] EMPTY_ARRAY = new ArgumentDescriptor[0];
    public static final ArgumentDescriptor[] ANON_REST = new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.anonrest)};
    public static final ArgumentDescriptor[] SYMBOL_PROC = new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.anonreq), new ArgumentDescriptor(ArgumentType.anonrest)};
    static final String ENCODING_DELIMETER = ";";
    static final byte[] ANONYMOUS_ENCODED = new byte[]{36, 110, 117, 108, 108, 36};

    public ArgumentDescriptor(ArgumentType type2, RubySymbol name2) {
        if (name2 == null && !type2.anonymous) {
            throw new RuntimeException("null argument name given for non-anonymous argument type");
        }
        this.type = type2;
        this.name = name2;
    }

    public ArgumentDescriptor(ArgumentType type2) {
        this(type2, null);
    }

    @Deprecated(since="10.0")
    public final RubyArray toArrayForm(Ruby runtime2, boolean isLambda) {
        return this.toArrayForm(runtime2.getCurrentContext(), isLambda);
    }

    public final RubyArray toArrayForm(ThreadContext context, boolean isLambda) {
        ArgumentType argType = this.type == ArgumentType.req && !isLambda ? ArgumentType.opt : this.type;
        RubySymbol name2 = this.name;
        if (!this.type.anonymous && name2.getBytes().length() == 0) {
            if (this.type == ArgumentType.rest) {
                name2 = Convert.asSymbol(context, "*");
            } else if (this.type == ArgumentType.keyrest) {
                name2 = Convert.asSymbol(context, "**");
            }
        }
        return argType.toArrayForm(context, name2);
    }

    public RubyString asParameterName(ThreadContext context) {
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case ArgumentType.req -> this.name.asString();
            case ArgumentType.opt -> ((RubyString)this.name.asString().dup()).catString("=...");
            case ArgumentType.key -> ((RubyString)this.name.asString().dup()).catString(": ...");
            case ArgumentType.keyreq -> ((RubyString)this.name.asString().dup()).catString(":");
            case ArgumentType.keyrest -> Create.newString(context, "**").cat(this.name.asString());
            case ArgumentType.block -> Create.newString(context, "&").cat(this.name.asString());
            case ArgumentType.rest -> Create.newString(context, "*").cat(this.name.asString());
            case ArgumentType.anonrest -> Create.newString(context, "*");
            case ArgumentType.anonkeyrest -> Create.newString(context, "**");
            case ArgumentType.anonreq, ArgumentType.anonopt -> Create.newString(context, "_");
            case ArgumentType.nokey -> Create.newString(context, "**nil");
        };
    }

    public static String encode(ArgumentDescriptor[] descriptors) {
        int length2 = descriptors.length;
        if (length2 == 0) {
            return "";
        }
        CharSequence[] encodedStringDescriptors = new String[descriptors.length];
        for (int i2 = 0; i2 < length2; ++i2) {
            byte[] id2 = descriptors[i2].name == null ? ANONYMOUS_ENCODED : descriptors[i2].name.idString().getBytes();
            byte[] entry = new byte[id2.length + 1];
            entry[0] = (byte)ArgumentType.prefixFrom(descriptors[i2].type);
            System.arraycopy(id2, 0, entry, 1, id2.length);
            encodedStringDescriptors[i2] = new String(entry, RubyEncoding.ISO);
        }
        return String.join((CharSequence)ENCODING_DELIMETER, encodedStringDescriptors);
    }

    public static ArgumentDescriptor[] decode(Ruby runtime2, String encodedDescriptors) {
        if (encodedDescriptors.isEmpty()) {
            return EMPTY_ARRAY;
        }
        String[] encodedStringDescriptors = encodedDescriptors.split(ENCODING_DELIMETER);
        int length2 = encodedStringDescriptors.length;
        ArgumentDescriptor[] descriptors = new ArgumentDescriptor[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            String descriptor = encodedStringDescriptors[i2];
            char type2 = descriptor.charAt(0);
            String id2 = descriptor.length() == 1 ? "" : descriptor.substring(1);
            boolean anonymous = Arrays.equals(ANONYMOUS_ENCODED, id2.getBytes(RubyEncoding.ISO));
            RubySymbol symbol = anonymous ? null : runtime2.newSymbol(id2);
            descriptors[i2] = new ArgumentDescriptor(ArgumentType.valueOf(type2), symbol);
        }
        return descriptors;
    }
}

