/*
 * Decompiled with CFR 0.152.
 */
package com.agafua.syslog;

import com.agafua.syslog.Adaptor;
import com.agafua.syslog.ConfigurationUtil;
import com.agafua.syslog.Facility;
import com.agafua.syslog.Message;
import com.agafua.syslog.TcpSender;
import com.agafua.syslog.Transport;
import com.agafua.syslog.UdpSender;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class SyslogHandler
extends Handler {
    private static final int LOG_QUEUE_SIZE = 1024;
    private static final String LOCALHOST = "localhost";
    private static final String MY_HOST_NAME = "0.0.0.0";
    private static final int DEFAULT_PORT = 514;
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;
    private static final String TRANSPORT_PROPERTY = "transport";
    private static final String HOSTNAME_PROPERTY = "hostname";
    private static final String PORT_PROPERTY = "port";
    private static final String FACILITY_PROPERTY = "facility";
    private static final String DAEMON_MODE_PROPERTY = "daemon";
    private static final String FORMATTER_PROPERTY = "formatter";
    private static final String ESCAPE_NEWLINES_PROPERTY = "escapeNewlines";
    private final String hostName;
    private final int port;
    private final Facility facility;
    private final Transport transport;
    private final Formatter formatter;
    private BlockingQueue<Message> blockingQueue = new ArrayBlockingQueue<Message>(1024);
    private boolean closed = false;
    private Thread worker;
    private volatile String myHostName;
    private Adaptor adaptor = new Adaptor();
    static final boolean escapeNewLines = SyslogHandler.parseEscapeNewlines();

    public SyslogHandler() {
        this.transport = this.parseTransport();
        this.hostName = this.parseHostName();
        this.port = this.parsePort();
        this.facility = this.parseFacility();
        this.formatter = this.parseFormatter();
        this.setFormatter(new SimpleFormatter());
        this.worker = Transport.TCP.equals((Object)this.transport) ? new Thread(new TcpSender(this.hostName, this.port, this.blockingQueue)) : new Thread(new UdpSender(this.hostName, this.port, this.blockingQueue));
        this.worker.start();
    }

    @Override
    public void publish(LogRecord record) {
        if (this.closed) {
            return;
        }
        try {
            Message message = new Message();
            String pri = this.adaptor.adaptPriority(record, this.facility);
            message.print(pri);
            String timestamp = this.adaptor.adaptTimeStamp(record);
            message.print(timestamp);
            message.print(" ");
            String host = this.getLocalHostname();
            message.print(host);
            message.print(" ");
            String msg = this.getFormatter().format(record);
            message.print(msg);
            this.blockingQueue.offer(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.blockingQueue.clear();
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = null;
        this.closed = true;
    }

    public String getTransport() {
        return this.transport.name();
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getFacility() {
        return this.facility.name();
    }

    private Transport parseTransport() {
        String transportValue = ConfigurationUtil.getStringPropertyOfLogHandlerClass(SyslogHandler.class, TRANSPORT_PROPERTY);
        for (Transport t : Transport.values()) {
            if (!t.name().equalsIgnoreCase(transportValue)) continue;
            return t;
        }
        return Transport.UDP;
    }

    private String parseHostName() {
        String hostNameValue = ConfigurationUtil.getStringPropertyOfLogHandlerClass(SyslogHandler.class, HOSTNAME_PROPERTY);
        if (hostNameValue != null && hostNameValue.length() > 0) {
            return hostNameValue;
        }
        return LOCALHOST;
    }

    private int parsePort() {
        String portValue = ConfigurationUtil.getStringPropertyOfLogHandlerClass(SyslogHandler.class, PORT_PROPERTY);
        if (portValue != null) {
            Integer p = null;
            try {
                p = Integer.parseInt(portValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (p != null && p >= 0 && p < 65535) {
                return p;
            }
        }
        return 514;
    }

    private Facility parseFacility() {
        String facilityValue = ConfigurationUtil.getStringPropertyOfLogHandlerClass(SyslogHandler.class, FACILITY_PROPERTY);
        for (Facility f : Facility.values()) {
            if (!f.name().equalsIgnoreCase(facilityValue)) continue;
            return f;
        }
        return Facility.USER;
    }

    private String getLocalHostname() {
        if (this.myHostName != null) {
            return this.myHostName;
        }
        try {
            String localHostName = InetAddress.getLocalHost().getHostName();
            if (localHostName != null) {
                this.myHostName = localHostName;
                return localHostName;
            }
        }
        catch (UnknownHostException localHostName) {
            // empty catch block
        }
        try {
            String localHostAddress = Inet4Address.getLocalHost().getHostAddress();
            if (localHostAddress != null) {
                this.myHostName = localHostAddress;
                return localHostAddress;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.myHostName = MY_HOST_NAME;
        return this.myHostName;
    }

    private Formatter parseFormatter() {
        Class<?> formatterClass = null;
        Formatter formatterInstance = null;
        String formatterClassProperty = ConfigurationUtil.getStringPropertyOfLogHandlerClass(SyslogHandler.class, FORMATTER_PROPERTY);
        if (formatterClassProperty != null) {
            try {
                formatterClass = ClassLoader.getSystemClassLoader().loadClass(formatterClassProperty);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (formatterClass != null) {
            try {
                formatterInstance = (Formatter)formatterClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (formatterInstance == null) {
            formatterInstance = new SimpleFormatter();
        }
        return formatterInstance;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    private static boolean parseEscapeNewlines() {
        String escapeProperty = ConfigurationUtil.getStringPropertyOfLogHandlerClass(SyslogHandler.class, ESCAPE_NEWLINES_PROPERTY);
        if (escapeProperty != null) {
            return Boolean.parseBoolean(escapeProperty);
        }
        return true;
    }
}

