/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class RepublishLeaseSetJob
extends JobImpl {
    private final Log _log;
    public static final long REPUBLISH_LEASESET_TIMEOUT = 60000L;
    private static final int RETRY_DELAY = 20000;
    private final Hash _dest;
    private final KademliaNetworkDatabaseFacade _facade;
    private long _lastPublished;

    public RepublishLeaseSetJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade, Hash destHash) {
        super(ctx);
        this._log = ctx.logManager().getLog(RepublishLeaseSetJob.class);
        this._facade = facade;
        this._dest = destHash;
    }

    @Override
    public String getName() {
        return "Republish a local leaseSet";
    }

    @Override
    public void runJob() {
        if (!this.getContext().clientManager().shouldPublishLeaseSet(this._dest)) {
            return;
        }
        try {
            if (this.getContext().clientManager().isLocal(this._dest)) {
                LeaseSet ls = this._facade.lookupLeaseSetLocally(this._dest);
                if (ls != null) {
                    if (!ls.isCurrent(60000L)) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn("Not publishing a LOCAL lease that isn't current - " + this._dest.toBase32(), new Exception("Publish expired LOCAL lease?"));
                        }
                    } else {
                        if (this._log.shouldInfo()) {
                            this._log.info(this.getJobId() + ": Publishing LS for " + this._dest.toBase32());
                        }
                        this.getContext().statManager().addRateData("netDb.republishLeaseSetCount", 1L);
                        this._facade.sendStore(this._dest, ls, null, new OnRepublishFailure(ls), 60000L, null);
                        this._lastPublished = this.getContext().clock().now();
                    }
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("Client " + this._dest.toBase32() + " is local, but we can't find a valid LeaseSet?  perhaps its being rebuilt?");
                }
                return;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Client " + this._dest.toBase32() + " is no longer local, so no more republishing their leaseSet");
            }
            this._facade.stopPublishing(this._dest);
        }
        catch (RuntimeException re) {
            if (this._log.shouldLog(40)) {
                this._log.error("Uncaught error republishing the leaseSet", re);
            }
            this._facade.stopPublishing(this._dest);
            throw re;
        }
    }

    void requeueRepublish() {
        if (this._log.shouldWarn()) {
            this._log.warn("Failed publishing of the leaseSet for " + this._dest.toBase32());
        }
        this.getContext().jobQueue().removeJob(this);
        this.requeue(20000 + this.getContext().random().nextInt(20000));
    }

    public long lastPublished() {
        return this._lastPublished;
    }

    private class OnRepublishFailure
    extends JobImpl {
        private final LeaseSet _ls;

        public OnRepublishFailure(LeaseSet ls) {
            super(RepublishLeaseSetJob.this.getContext());
            this._ls = ls;
        }

        @Override
        public String getName() {
            return "Publish leaseSet failed";
        }

        @Override
        public void runJob() {
            LeaseSet ls = RepublishLeaseSetJob.this._facade.lookupLeaseSetLocally(this._ls.getHash());
            if (ls != null && !KademliaNetworkDatabaseFacade.isNewer(ls, this._ls)) {
                RepublishLeaseSetJob.this.requeueRepublish();
            } else if (RepublishLeaseSetJob.this._log.shouldWarn()) {
                RepublishLeaseSetJob.this._log.warn(this.getJobId() + ": Failed publishing LS for " + this._ls.getDestination().toBase32() + " but not requeueing, there is a newer LS");
            }
        }
    }
}

