/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.codehaus.xfire.gen.BaseServicesGenTask;
import org.codehaus.xfire.service.Service;

public class WsdlGenTask
extends BaseServicesGenTask {
    private static final Log LOGGER = LogFactory.getLog(WsdlGenTask.class);
    private String outputDirectory;
    private File generatedFile;
    private File outputDir;

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private static Log getLogger() {
        return LOGGER;
    }

    public File getGeneratedFile() {
        return this.generatedFile;
    }

    public void execute() throws BuildException {
        this.outputDir = new File(this.outputDirectory);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            WsdlGenTask.getLogger().warn((Object)("the output directory " + this.outputDirectory + " doesn't exist and couldn't be created. The task with probably fail."));
        }
        this.iterateServices();
    }

    protected void processService(Service service) {
        FileOutputStream out;
        String serviceName = service.getName().getLocalPart();
        File outputFile = new File(this.outputDir, serviceName + ".wsdl");
        try {
            out = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Unable to generate WSDL: output file " + outputFile + " not found", (Throwable)e);
        }
        BufferedOutputStream stream = new BufferedOutputStream(out);
        try {
            service.getWSDLWriter().write(stream);
        }
        catch (IOException e) {
            throw new BuildException("Unable to generate WSDL.", (Throwable)e);
        }
        this.generatedFile = outputFile;
    }
}

