/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Map;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;

final class XMLDSigSecurity {
    private XMLDSigSecurity() {
    }

    private static ProviderProperty getEngineClassName(String string, Map.Entry entry, String string2, String string3, boolean bl) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        boolean bl2 = false;
        ProviderProperty providerProperty = null;
        for (int i = 0; i < providerArray.length && !bl2; ++i) {
            try {
                providerProperty = XMLDSigSecurity.getEngineClassName(string, entry, string2, string3, providerArray[i], bl);
                bl2 = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl2) {
            if (bl) {
                throw new NoSuchMechanismException("Mechanism type " + string + " not available");
            }
            throw new NoSuchAlgorithmException("Algorithm type " + string + " not available");
        }
        return providerProperty;
    }

    private static ProviderProperty getEngineClassName(String string, Map.Entry entry, String string2, String string3, Provider provider, boolean bl) throws NoSuchAlgorithmException {
        Object object;
        String string4 = XMLDSigSecurity.getProviderProperty(string3, entry, provider);
        if (string4 == null) {
            object = XMLDSigSecurity.getStandardName(string, string2, provider);
            if (object != null) {
                string3 = string2 + "." + (String)object;
            }
            if (object == null || (string4 = XMLDSigSecurity.getProviderProperty(string3, entry, provider)) == null) {
                if (bl) {
                    throw new NoSuchMechanismException("no such mechanism type: " + string + " for provider " + provider.getName());
                }
                throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + provider.getName());
            }
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).className = string4;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    static Object[] getImpl(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        return XMLDSigSecurity.getImpl(string, null, string2, provider);
    }

    static Object[] getImpl(String string, Map.Entry entry, String string2, Provider provider) throws NoSuchAlgorithmException {
        Class clazz = null;
        boolean bl = true;
        if (string2.equals("XMLSignatureFactory")) {
            clazz = XMLSignatureFactory.class;
        } else if (string2.equals("KeyInfoFactory")) {
            clazz = KeyInfoFactory.class;
        } else if (string2.equals("TransformService")) {
            clazz = TransformService.class;
            bl = false;
        }
        String string3 = string2 + "." + string;
        if (provider == null) {
            return XMLDSigSecurity.doGetImpl(string2, clazz, XMLDSigSecurity.getEngineClassName(string, entry, string2, string3, bl), bl);
        }
        return XMLDSigSecurity.doGetImpl(string2, clazz, XMLDSigSecurity.getEngineClassName(string, entry, string2, string3, provider, bl), bl);
    }

    private static Object[] doGetImpl(String string, Class clazz, ProviderProperty providerProperty, boolean bl) throws NoSuchAlgorithmException {
        String string2 = providerProperty.className;
        String string3 = providerProperty.provider.getName();
        try {
            ClassLoader classLoader = providerProperty.provider.getClass().getClassLoader();
            Class<?> clazz2 = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
            if (XMLDSigSecurity.checkSuperclass(clazz2, clazz)) {
                return new Object[]{clazz2.newInstance(), providerProperty.provider};
            }
            if (bl) {
                throw new NoSuchMechanismException("class configured for " + string + ": " + string2 + " not a " + string);
            }
            throw new NoSuchAlgorithmException("class configured for " + string + ": " + string2 + " not a " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                throw new NoSuchMechanismException("class configured for " + string + "(provider: " + string3 + ")" + "cannot be found.\n", classNotFoundException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class configured for " + string + "(provider: " + string3 + ")" + "cannot be found.\n").initCause(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            if (bl) {
                throw new NoSuchMechanismException("class " + string2 + " configured for " + string + "(provider: " + string3 + ") cannot be " + "instantiated. ", instantiationException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + string2 + " configured for " + string + "(provider: " + string3 + ") cannot be " + "instantiated. ").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (bl) {
                throw new NoSuchMechanismException("class " + string2 + " configured for " + string + "(provider: " + string3 + ") cannot be accessed.\n", illegalAccessException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + string2 + " configured for " + string + "(provider: " + string3 + ") cannot be accessed.\n").initCause(illegalAccessException);
        }
    }

    private static String getProviderProperty(String string, Map.Entry entry, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration<Object> enumeration = provider.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                string2 = provider.getProperty(string3);
                break;
            }
        }
        if (!(string2 == null || entry == null || provider.entrySet().contains(entry) || entry.getValue().equals("DOM") && provider.get(entry.getKey()) == null)) {
            string2 = null;
        }
        return string2;
    }

    private static String getStandardName(String string, String string2, Provider provider) {
        return XMLDSigSecurity.getProviderProperty("Alg.Alias." + string2 + "." + string, null, provider);
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

