/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.serializer;

import de.rub.nds.asn1.model.Asn1Implicit;
import de.rub.nds.asn1.serializer.Asn1FieldSerializer;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayExplicitValueModification;
import java.util.Arrays;

public class Asn1ImplicitSerializer
extends Asn1FieldSerializer {
    private final Asn1Implicit asn1Implicit;

    public Asn1ImplicitSerializer(Asn1Implicit asn1Implicit) {
        super(asn1Implicit);
        this.asn1Implicit = asn1Implicit;
    }

    @Override
    public void updateLayers() {
        this.encodeImplicit();
        super.updateLayers();
    }

    private void encodeImplicit() {
        int offset = this.asn1Implicit.getOffset();
        this.asn1Implicit.getTagNumber().setOriginalValue(Integer.valueOf(offset));
        byte[] content = this.asn1Implicit.getEncodedChildren();
        boolean constructed = (content[0] & 0x20) >> 5 == 1;
        this.asn1Implicit.setTagConstructedModification(constructed);
        int tagNumber = content[0] & 0x1F;
        int i = 1;
        if (tagNumber >= 31) {
            while ((content[i] & 0x80) == 1) {
                ++i;
            }
        }
        int j = i;
        while ((content[j] & 0x80) == 1) {
            ++j;
        }
        byte[] length = Arrays.copyOfRange(content, i, j - i + 1);
        this.asn1Implicit.getLengthOctets().setModification((VariableModification)new ByteArrayExplicitValueModification(length));
        this.asn1Implicit.setContent(Arrays.copyOfRange(content, j, content.length));
    }
}

