/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.EntrySupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChildrenArray
extends NodeAdapter {
    public EntrySupport.Default entrySupport;
    private Node[] nodes;
    private Map<EntrySupport.Default.Info, Collection<Node>> map;
    private Reference<ChildrenArray> ref;
    private static final Logger LOG_NODES_FOR = Logger.getLogger("org.openide.nodes.ChildrenArray.nodesFor");

    public Children getChildren() {
        return this.entrySupport == null ? null : this.entrySupport.children;
    }

    protected void finalize() {
        this.entrySupport.finalizedChildrenArray(this.ref);
    }

    final void pointedBy(Reference<ChildrenArray> reference) {
        this.ref = reference;
    }

    public Node[] nodes() {
        if (this.entrySupport == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.entrySupport.justComputeNodes();
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].reassignTo(this.entrySupport.children, this);
            }
            this.entrySupport.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    public void clear() {
        if (this.nodes != null) {
            this.nodes = null;
            this.entrySupport.registerChildrenArray(this, false);
        }
    }

    public void finalizeNodes() {
        Map<EntrySupport.Default.Info, Collection<Node>> map = this.map;
        if (map != null) {
            map.remove(null);
        }
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    private String logInfo(EntrySupport.Default.Info info) {
        return info.toString() + '[' + Integer.toHexString(System.identityHashCode(info)) + ']';
    }

    public synchronized Collection<Node> nodesFor(EntrySupport.Default.Info info) {
        boolean bl = LOG_NODES_FOR.isLoggable(Level.FINE);
        if (bl) {
            LOG_NODES_FOR.finer("nodesFor(" + this.logInfo(info) + ") on " + Thread.currentThread());
        }
        if (this.map == null) {
            this.map = new WeakHashMap<EntrySupport.Default.Info, Collection<Node>>(7);
        }
        Collection<Node> collection = this.map.get(info);
        if (bl) {
            LOG_NODES_FOR.finer("  map size=" + this.map.size() + ", nodes=" + collection);
        }
        if (collection == null) {
            collection = info.entry.nodes(null);
            info.length = collection.size();
            this.map.put(info, collection);
            if (bl) {
                LOG_NODES_FOR.finer("  created nodes=" + collection);
            }
        }
        if (bl) {
            LOG_NODES_FOR.finer("  leaving nodesFor(" + this.logInfo(info) + ") on " + Thread.currentThread());
        }
        return collection;
    }

    public synchronized void useNodes(EntrySupport.Default.Info info, Collection<Node> collection) {
        if (this.map == null) {
            this.map = new WeakHashMap<EntrySupport.Default.Info, Collection<Node>>(7);
        }
        info.length = collection.size();
        this.map.put(info, collection);
    }

    public String toString() {
        return super.toString() + "  " + this.getChildren();
    }
}

