info = {
    "name": "nb",
    "date_order": "DMY",
    "january": [
        "jan",
        "januar"
    ],
    "february": [
        "feb",
        "februar"
    ],
    "march": [
        "mar",
        "mars"
    ],
    "april": [
        "apr",
        "april"
    ],
    "may": [
        "mai"
    ],
    "june": [
        "jun",
        "juni"
    ],
    "july": [
        "jul",
        "juli"
    ],
    "august": [
        "aug",
        "august"
    ],
    "september": [
        "sep",
        "september"
    ],
    "october": [
        "okt",
        "oktober"
    ],
    "november": [
        "nov",
        "november"
    ],
    "december": [
        "des",
        "desember"
    ],
    "monday": [
        "man",
        "mandag"
    ],
    "tuesday": [
        "tir",
        "tirsdag"
    ],
    "wednesday": [
        "ons",
        "onsdag"
    ],
    "thursday": [
        "tor",
        "torsdag"
    ],
    "friday": [
        "fre",
        "fredag"
    ],
    "saturday": [
        "lør",
        "lørdag"
    ],
    "sunday": [
        "søn",
        "søndag"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "år"
    ],
    "month": [
        "md",
        "mnd",
        "måned"
    ],
    "week": [
        "u",
        "uke",
        "uker"
    ],
    "day": [
        "d",
        "dag",
        "dager"
    ],
    "hour": [
        "t",
        "time",
        "timer"
    ],
    "minute": [
        "m",
        "min",
        "minutt"
    ],
    "second": [
        "s",
        "sek",
        "sekund"
    ],
    "relative-type": {
        "0 day ago": [
            "i dag"
        ],
        "0 hour ago": [
            "denne timen"
        ],
        "0 minute ago": [
            "dette minuttet"
        ],
        "0 month ago": [
            "denne md",
            "denne måneden"
        ],
        "0 second ago": [
            "nå"
        ],
        "0 week ago": [
            "denne uken"
        ],
        "0 year ago": [
            "i år"
        ],
        "1 day ago": [
            "i går"
        ],
        "1 month ago": [
            "forrige md",
            "forrige måned"
        ],
        "1 week ago": [
            "forrige uke"
        ],
        "1 year ago": [
            "i fjor"
        ],
        "in 1 day": [
            "i morgen"
        ],
        "in 1 month": [
            "neste md",
            "neste måned"
        ],
        "in 1 week": [
            "neste uke"
        ],
        "in 1 year": [
            "neste år"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "for (\\d+[.,]?\\d*) d siden",
            "for (\\d+[.,]?\\d*) døgn siden",
            "for (\\d+[.,]?\\d*) dager siden"
        ],
        "\\1 hour ago": [
            "for (\\d+[.,]?\\d*) t siden",
            "for (\\d+[.,]?\\d*) time siden",
            "for (\\d+[.,]?\\d*) timer siden"
        ],
        "\\1 minute ago": [
            "for (\\d+[.,]?\\d*) min siden",
            "for (\\d+[.,]?\\d*) minutt siden",
            "for (\\d+[.,]?\\d*) minutter siden"
        ],
        "\\1 month ago": [
            "for (\\d+[.,]?\\d*) md siden",
            "for (\\d+[.,]?\\d*) måned siden",
            "for (\\d+[.,]?\\d*) måneder siden"
        ],
        "\\1 second ago": [
            "for (\\d+[.,]?\\d*) sek siden",
            "for (\\d+[.,]?\\d*) sekund siden",
            "for (\\d+[.,]?\\d*) sekunder siden"
        ],
        "\\1 week ago": [
            "for (\\d+[.,]?\\d*) u siden",
            "for (\\d+[.,]?\\d*) uke siden",
            "for (\\d+[.,]?\\d*) uker siden"
        ],
        "\\1 year ago": [
            "for (\\d+[.,]?\\d*) år siden",
            "–(\\d+[.,]?\\d*) år"
        ],
        "in \\1 day": [
            "om (\\d+[.,]?\\d*) d",
            "om (\\d+[.,]?\\d*) døgn"
        ],
        "in \\1 hour": [
            "om (\\d+[.,]?\\d*) t",
            "om (\\d+[.,]?\\d*) time",
            "om (\\d+[.,]?\\d*) timer"
        ],
        "in \\1 minute": [
            "om (\\d+[.,]?\\d*) min",
            "om (\\d+[.,]?\\d*) minutt",
            "om (\\d+[.,]?\\d*) minutter"
        ],
        "in \\1 month": [
            "om (\\d+[.,]?\\d*) md",
            "om (\\d+[.,]?\\d*) måned",
            "om (\\d+[.,]?\\d*) måneder"
        ],
        "in \\1 second": [
            "om (\\d+[.,]?\\d*) sek",
            "om (\\d+[.,]?\\d*) sekund",
            "om (\\d+[.,]?\\d*) sekunder"
        ],
        "in \\1 week": [
            "om (\\d+[.,]?\\d*) u",
            "om (\\d+[.,]?\\d*) uke",
            "om (\\d+[.,]?\\d*) uker"
        ],
        "in \\1 year": [
            "om (\\d+[.,]?\\d*) år"
        ]
    },
    "locale_specific": {
        "nb-SJ": {
            "name": "nb-SJ"
        }
    },
    "ago": [
        "siden"
    ],
    "in": [
        "om"
    ],
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
