/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.classgen.ReflectorGenerator;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.MethodHelper;
import org.codehaus.groovy.runtime.ReferenceMap;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.ReflectorLoader;
import org.objectweb.asm.ClassWriter;

public class MetaClassRegistry {
    private ReferenceMap metaClasses = new ReferenceMap();
    private ReferenceMap loaderMap = new ReferenceMap();
    private boolean useAccessible;
    private LinkedList instanceMethods = new LinkedList();
    private LinkedList staticMethods = new LinkedList();
    public static final int LOAD_DEFAULT = 0;
    public static final int DONT_LOAD_DEFAULT = 1;
    private static MetaClassRegistry instanceInclude;
    private static MetaClassRegistry instanceExclude;

    public MetaClassRegistry() {
        this(0, true);
    }

    public MetaClassRegistry(int loadDefault) {
        this(loadDefault, true);
    }

    public MetaClassRegistry(boolean useAccessible) {
        this(0, useAccessible);
    }

    public MetaClassRegistry(int loadDefault, boolean useAccessible) {
        this.useAccessible = useAccessible;
        if (loadDefault == 0) {
            this.registerMethods(DefaultGroovyMethods.class, true);
            this.registerMethods(DefaultGroovyStaticMethods.class, false);
        }
    }

    private void registerMethods(Class theClass, boolean useInstanceMethods) {
        Method[] methods = theClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (!MethodHelper.isStatic(method) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
            if (useInstanceMethods) {
                this.instanceMethods.add(method);
                continue;
            }
            this.staticMethods.add(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Class theClass) {
        Class clazz = theClass;
        synchronized (clazz) {
            MetaClass answer = (MetaClass)this.metaClasses.get(theClass);
            if (answer == null) {
                answer = this.getMetaClassFor(theClass);
                answer.initialize();
                this.metaClasses.put(theClass, answer);
            }
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaClass(Class theClass) {
        Class clazz = theClass;
        synchronized (clazz) {
            this.metaClasses.remove(theClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaClass(Class theClass, MetaClass theMetaClass) {
        Class clazz = theClass;
        synchronized (clazz) {
            this.metaClasses.putStrong(theClass, theMetaClass);
        }
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReflectorLoader getReflectorLoader(final ClassLoader loader) {
        ReferenceMap referenceMap = this.loaderMap;
        synchronized (referenceMap) {
            ReflectorLoader reflectorLoader = (ReflectorLoader)this.loaderMap.get(loader);
            if (reflectorLoader == null) {
                reflectorLoader = (ReflectorLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ReflectorLoader(loader);
                    }
                });
                this.loaderMap.put(loader, reflectorLoader);
            }
            return reflectorLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetaClass lookup(Class theClass) {
        Class clazz = theClass;
        synchronized (clazz) {
            MetaClass answer = (MetaClass)this.metaClasses.get(theClass);
            if (answer == null) {
                answer = this.getMetaClassFor(theClass);
                this.metaClasses.put(theClass, answer);
            }
            return answer;
        }
    }

    private MetaClass getMetaClassFor(Class theClass) {
        try {
            Class<?> customMetaClass = Class.forName("groovy.runtime.metaclass." + theClass.getName() + "MetaClass");
            Constructor<?> customMetaClassConstructor = customMetaClass.getConstructor(MetaClassRegistry.class, Class.class);
            return (MetaClass)customMetaClassConstructor.newInstance(this, theClass);
        }
        catch (ClassNotFoundException e) {
            return new MetaClassImpl(this, theClass);
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not instantiate custom Metaclass for class: " + theClass.getName() + ". Reason: " + e, e);
        }
    }

    public static MetaClassRegistry getInstance(int includeExtension) {
        if (includeExtension != 1) {
            if (instanceInclude == null) {
                instanceInclude = new MetaClassRegistry();
            }
            return instanceInclude;
        }
        if (instanceExclude == null) {
            instanceExclude = new MetaClassRegistry(1);
        }
        return instanceExclude;
    }

    public synchronized Reflector loadReflector(final Class theClass, List methods) {
        final String name = this.getReflectorName(theClass);
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader loader = theClass.getClassLoader();
                if (loader == null) {
                    loader = this.getClass().getClassLoader();
                }
                return loader;
            }
        });
        final ReflectorLoader rloader = this.getReflectorLoader(loader);
        Class ref = rloader.getLoadedClass(name);
        if (ref == null) {
            ReflectorGenerator generator = new ReflectorGenerator(methods);
            ClassWriter cw = new ClassWriter(true);
            generator.generate(cw, name);
            final byte[] bytecode = cw.toByteArray();
            ref = (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return rloader.defineClass(name, bytecode, this.getClass().getProtectionDomain());
                }
            });
        }
        try {
            return (Reflector)ref.newInstance();
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not generate and load the reflector for class: " + name + ". Reason: " + e, e);
        }
    }

    private String getReflectorName(Class theClass) {
        String className = theClass.getName();
        String packagePrefix = "gjdk.";
        String name = packagePrefix + className + "_GroovyReflector";
        if (theClass.isArray()) {
            Class<?> clazz = theClass;
            name = packagePrefix;
            int level = 0;
            while (clazz.isArray()) {
                clazz = clazz.getComponentType();
                ++level;
            }
            String componentName = clazz.getName();
            name = packagePrefix + componentName + "_GroovyReflectorArray";
            if (level > 1) {
                name = name + level;
            }
        }
        return name;
    }

    List getInstanceMethods() {
        return this.instanceMethods;
    }

    List getStaticMethods() {
        return this.staticMethods;
    }
}

