/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.security.asn1.ASN1Exception;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Context;
import com.ca.commons.security.asn1.Sequence;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.StringTokenizer;

public class DERCoder
implements Serializable {
    public byte[] encode(ASN1Object input) throws ASN1Exception {
        int length;
        byte[] buffer = new byte[8192];
        try {
            length = this.encode(input, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ASN1Exception("ASN.1 Object too big");
        }
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[length - i - 1] = buffer[i];
        }
        return result;
    }

    public int encode(ASN1Object input, byte[] buffer, int offset) throws ASN1Exception {
        int tag = input.getASN1Type().getTag();
        switch (tag) {
            case 1: {
                return this.encodeBOOLEAN(input, buffer, offset);
            }
            case 2: {
                return this.encodeINTEGER(input, buffer, offset);
            }
            case 3: {
                return this.encodeBITSTRING(input, buffer, offset);
            }
            case 4: {
                return this.encodeOCTETSTRING(input, buffer, offset);
            }
            case 5: {
                return this.encodeNULL(input, buffer, offset);
            }
            case 6: {
                return this.encodeOBJECTID(input, buffer, offset);
            }
            case 10: {
                return this.encodeENUMERATED(input, buffer, offset);
            }
            case 19: {
                return this.encodePrintableString(input, buffer, offset);
            }
            case 20: 
            case 22: {
                return this.encodeIA5String(input, buffer, offset);
            }
            case 23: {
                return this.encodeUTCTime(input, buffer, offset);
            }
            case 24: {
                return this.encodeGeneralizedTime(input, buffer, offset);
            }
            case 28: {
                return this.encodeUniversalString(input, buffer, offset);
            }
            case 30: {
                return this.encodeBMPSTRING(input, buffer, offset);
            }
            case 48: 
            case 49: {
                return this.encodeSEQUENCE((Sequence)input, buffer, offset);
            }
            case 128: {
                return this.encodeCONTEXT(input, buffer, offset);
            }
        }
        throw new ASN1Exception(input.getASN1Type().toString() + " -- Unknown type");
    }

    private int encodeLength(int length, byte[] stream, int offset) {
        if (length >= 0 && length <= 127) {
            stream[offset++] = (byte)length;
        } else {
            int count = 0;
            while (length != 0) {
                stream[offset++] = (byte)length;
                length >>>= 8;
                ++count;
            }
            stream[offset++] = (byte)(count | 0x80);
        }
        return offset;
    }

    private int encodeBOOLEAN(ASN1Object o, byte[] stream, int offset) {
        boolean v = (Boolean)o.getValue();
        stream[offset++] = (byte)(v ? 1 : 0);
        stream[offset++] = 1;
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeINTEGER(ASN1Object o, byte[] stream, int offset) {
        BigInteger v = (BigInteger)o.getValue();
        byte[] content = v.toByteArray();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeENUMERATED(ASN1Object o, byte[] stream, int offset) {
        BigInteger v = (BigInteger)o.getValue();
        byte[] content = v.toByteArray();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeSEQUENCE(ASN1Object o, byte[] stream, int offset) throws ASN1Exception {
        int start = offset;
        for (int i = o.size() - 1; i >= 0; --i) {
            offset = this.encode(o.getComponent(i), stream, offset);
        }
        offset = this.encodeLength(offset - start, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeBITSTRING(ASN1Object o, byte[] stream, int offset) {
        byte[] content = (byte[])o.getValue();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        stream[offset++] = 0;
        offset = this.encodeLength(content.length + 1, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeOCTETSTRING(ASN1Object o, byte[] stream, int offset) {
        byte[] content = (byte[])o.getValue();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeUniversalString(ASN1Object o, byte[] stream, int offset) {
        byte[] content = (byte[])o.getValue();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeBMPSTRING(ASN1Object o, byte[] stream, int offset) {
        byte[] content = (byte[])o.getValue();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeOBJECTID(ASN1Object o, byte[] stream, int offset) {
        int i;
        String id = (String)o.getValue();
        StringTokenizer st = new StringTokenizer(id, " ");
        String[] subid = new String[st.countTokens()];
        int start = offset;
        for (i = 0; i < subid.length; ++i) {
            subid[i] = st.nextToken();
        }
        for (i = subid.length - 1; i > 1; --i) {
            long s = Long.parseLong(subid[i]);
            stream[offset++] = (byte)(s & 0x7FL);
            s >>>= 7;
            while (s != 0L) {
                stream[offset++] = (byte)(s | 0x80L);
                s >>>= 7;
            }
        }
        long l = Long.parseLong(subid[0]) * 40L + Long.parseLong(subid[1]);
        stream[offset++] = (byte)l;
        offset = this.encodeLength(offset - start, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeUTCTime(ASN1Object o, byte[] stream, int offset) {
        String time = (String)o.getValue();
        byte[] t = time.getBytes();
        for (int i = t.length - 1; i >= 0; --i) {
            stream[offset++] = t[i];
        }
        offset = this.encodeLength(t.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeGeneralizedTime(ASN1Object o, byte[] stream, int offset) {
        String time = (String)o.getValue();
        byte[] t = time.getBytes();
        for (int i = t.length - 1; i >= 0; --i) {
            stream[offset++] = t[i];
        }
        offset = this.encodeLength(t.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodePrintableString(ASN1Object o, byte[] stream, int offset) {
        String s = (String)o.getValue();
        byte[] content = s.getBytes();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeIA5String(ASN1Object o, byte[] stream, int offset) {
        String s = (String)o.getValue();
        byte[] content = s.getBytes();
        for (int i = content.length - 1; i >= 0; --i) {
            stream[offset++] = content[i];
        }
        offset = this.encodeLength(content.length, stream, offset);
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeNULL(ASN1Object o, byte[] stream, int offset) {
        stream[offset++] = 0;
        stream[offset++] = (byte)o.getASN1Type().getTag();
        return offset;
    }

    private int encodeCONTEXT(ASN1Object o, byte[] stream, int offset) throws ASN1Exception {
        ASN1Object v = (ASN1Object)o.getValue();
        int start = offset;
        if (o.implicit()) {
            if ((o.getTag() & 0x20) == 0) {
                int i;
                int i2;
                byte[] data = null;
                if (v.getASN1Type().equals(ASN1Type.BOOLEAN)) {
                    boolean b = (Boolean)v.getValue();
                    stream[offset++] = (byte)(b ? 1 : 0);
                    stream[offset++] = 1;
                }
                if (v.getASN1Type().equals(ASN1Type.OCTET_STRING)) {
                    data = (byte[])v.getValue();
                    for (int i3 = data.length - 1; i3 >= 0; --i3) {
                        stream[offset++] = data[i3];
                    }
                    offset = this.encodeLength(data.length, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.IA5String)) {
                    String s = (String)v.getValue();
                    data = s.getBytes();
                    for (i2 = data.length - 1; i2 >= 0; --i2) {
                        stream[offset++] = data[i2];
                    }
                    offset = this.encodeLength(data.length, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.INTEGER)) {
                    BigInteger tmp = (BigInteger)v.getValue();
                    data = tmp.toByteArray();
                    for (i2 = data.length - 1; i2 >= 0; --i2) {
                        stream[offset++] = data[i2];
                    }
                    offset = this.encodeLength(data.length, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.UTCTime)) {
                    String time = (String)v.getValue();
                    byte[] t = time.getBytes();
                    for (i = t.length - 1; i >= 0; --i) {
                        stream[offset++] = t[i];
                    }
                    offset = this.encodeLength(t.length, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.GENERALIZEDTIME)) {
                    String time = (String)v.getValue();
                    byte[] t = time.getBytes();
                    for (i = t.length - 1; i >= 0; --i) {
                        stream[offset++] = t[i];
                    }
                    offset = this.encodeLength(t.length, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.BIT_STRING)) {
                    byte[] content = (byte[])v.getValue();
                    for (int i4 = content.length - 1; i4 >= 0; --i4) {
                        stream[offset++] = content[i4];
                    }
                    stream[offset++] = 0;
                    offset = this.encodeLength(content.length + 1, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.ENUMERATED)) {
                    BigInteger tmp = (BigInteger)v.getValue();
                    data = tmp.toByteArray();
                    for (int i5 = data.length - 1; i5 >= 0; --i5) {
                        stream[offset++] = data[i5];
                    }
                    offset = this.encodeLength(data.length, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.OBJECT_ID)) {
                    int i6;
                    String id = (String)v.getValue();
                    StringTokenizer st = new StringTokenizer(id, " ");
                    String[] subid = new String[st.countTokens()];
                    for (i6 = 0; i6 < subid.length; ++i6) {
                        subid[i6] = st.nextToken();
                    }
                    for (i6 = subid.length - 1; i6 > 1; --i6) {
                        long s = Long.parseLong(subid[i6]);
                        stream[offset++] = (byte)(s & 0x7FL);
                        s >>>= 7;
                        while (s != 0L) {
                            stream[offset++] = (byte)(s | 0x80L);
                            s >>>= 7;
                        }
                    }
                    long l = Long.parseLong(subid[0]) * 40L + Long.parseLong(subid[1]);
                    stream[offset++] = (byte)l;
                    offset = this.encodeLength(offset - start, stream, offset);
                }
                if (v.getASN1Type().equals(ASN1Type.SEQUENCE) || v.getASN1Type().equals(ASN1Type.SET)) {
                    start = offset;
                    for (int i7 = v.size() - 1; i7 >= 0; --i7) {
                        offset = this.encode(v.getComponent(i7), stream, offset);
                    }
                    offset = this.encodeLength(offset - start, stream, offset);
                    stream[offset++] = (byte)(0xA0 | o.getTag());
                    return offset;
                }
                stream[offset++] = (byte)(0x80 | o.getTag());
            } else {
                offset = this.encode(v, stream, offset);
                stream[offset - 1] = (byte)(0xA0 | o.getTag());
            }
        } else {
            offset = this.encode(v, stream, offset);
            offset = this.encodeLength(offset - start, stream, offset);
            stream[offset++] = (byte)(0xA0 | o.getTag());
        }
        return offset;
    }

    public ASN1Object decode(byte[] buffer) throws ASN1Exception {
        int[] offset = new int[]{0};
        return this.decode(buffer, offset);
    }

    public ASN1Object decode(byte[] buffer, int[] offset) throws ASN1Exception {
        int start = offset[0];
        int n = offset[0];
        offset[0] = n + 1;
        int tag = buffer[n];
        int oldTag = 0;
        if ((tag & 0x80) != 0 && (tag & 0x40) == 0) {
            oldTag = tag;
            tag = 128;
        }
        ASN1Type type = new ASN1Type(tag);
        ASN1Object object = ASN1Object.create(type);
        int length = this.decodeLength(buffer, offset);
        if (length < 0 && length != -1) {
            throw new ASN1Exception("Invalid object length (" + length + ")");
        }
        switch (tag) {
            case 1: {
                this.decodeBOOLEAN(object, buffer, offset, length);
                break;
            }
            case 2: {
                this.decodeINTEGER(object, buffer, offset, length);
                break;
            }
            case 3: {
                this.decodeBITSTRING(object, buffer, offset, length);
                break;
            }
            case 4: {
                this.decodeOCTETSTRING(object, buffer, offset, length);
                break;
            }
            case 5: {
                this.decodeNULL(object, buffer, offset, length);
                break;
            }
            case 6: {
                this.decodeOBJECTID(object, buffer, offset, length);
                break;
            }
            case 10: {
                this.decodeENUMERATED(object, buffer, offset, length);
                break;
            }
            case 19: {
                this.decodePrintableString(object, buffer, offset, length);
                break;
            }
            case 20: 
            case 22: {
                this.decodeIA5String(object, buffer, offset, length);
                break;
            }
            case 23: {
                this.decodeUTCTime(object, buffer, offset, length);
                break;
            }
            case 24: {
                this.decodeGeneralizedTime(object, buffer, offset, length);
                break;
            }
            case 28: {
                this.decodeUniversalString(object, buffer, offset, length);
                break;
            }
            case 30: {
                this.decodeBMPSTRING(object, buffer, offset, length);
                break;
            }
            case 48: 
            case 49: {
                this.decodeSEQUENCE(object, buffer, offset, length);
                break;
            }
            case 128: {
                this.decodeCONTEXT(object, buffer, offset, length, oldTag);
                break;
            }
            default: {
                throw new ASN1Exception("Unknow ASN.1 tag --" + tag);
            }
        }
        byte[] der = new byte[offset[0] - start];
        System.arraycopy(buffer, start, der, 0, offset[0] - start);
        object.setByteArray(der);
        return object;
    }

    private int decodeLength(byte[] stream, int[] offset) throws ASN1Exception {
        int n = offset[0];
        offset[0] = n + 1;
        int length = stream[n] & 0xFF;
        if ((length & 0x80) != 0) {
            int count = length & 0x7F;
            if (count > 4) {
                throw new ASN1Exception("ASN.1 Object too large");
            }
            if (count == 0) {
                return -1;
            }
            int n2 = offset[0];
            offset[0] = n2 + 1;
            length = stream[n2] & 0xFF;
            for (int i = 1; i < count; ++i) {
                length <<= 8;
                int n3 = offset[0];
                offset[0] = n3 + 1;
                length |= stream[n3] & 0xFF;
            }
        }
        return length;
    }

    private void decodeBOOLEAN(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length != 1) {
            throw new ASN1Exception("Wrong data (BOOLEAN) length");
        }
        boolean v = stream[offset[0]] != 0;
        o.setValue(new Boolean(v));
        offset[0] = offset[0] + 1;
    }

    private void decodeINTEGER(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length < 1) {
            throw new ASN1Exception("Wrong data (INTEGER) length");
        }
        byte[] content = new byte[length];
        System.arraycopy(stream, offset[0], content, 0, length);
        BigInteger v = new BigInteger(content);
        o.setValue(v);
        offset[0] = offset[0] + length;
    }

    private void decodeENUMERATED(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length < 1) {
            throw new ASN1Exception("Wrong data (INTEGER) length");
        }
        byte[] content = new byte[length];
        System.arraycopy(stream, offset[0], content, 0, length);
        BigInteger v = new BigInteger(content);
        o.setValue(v);
        offset[0] = offset[0] + length;
    }

    private void decodeSEQUENCE(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        block5: {
            int start = offset[0];
            if (length == -1) {
                while (true) {
                    if (stream[offset[0]] == 0 && stream[offset[0] + 1] == 0) {
                        offset[0] = offset[0] + 2;
                        break block5;
                    }
                    o.addComponent(this.decode(stream, offset));
                }
            }
            while (offset[0] < start + length) {
                o.addComponent(this.decode(stream, offset));
            }
            if (offset[0] != start + length) {
                throw new ASN1Exception("Wrong data (SEQUENCE) length");
            }
        }
    }

    private void decodeBITSTRING(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length != -1) {
            if (length < 1) {
                throw new ASN1Exception("Wrong data (BIT STRING) length");
            }
            byte[] content = new byte[length];
            System.arraycopy(stream, offset[0], content, 0, length);
            o.setValue(content);
            offset[0] = offset[0] + length;
        }
    }

    private void decodeOCTETSTRING(ASN1Object o, byte[] stream, int[] offset, int length) {
        if (length != -1) {
            byte[] content = new byte[length];
            System.arraycopy(stream, offset[0], content, 0, length);
            o.setValue(content);
            offset[0] = offset[0] + length;
        }
    }

    private void decodeUniversalString(ASN1Object o, byte[] stream, int[] offset, int length) {
        if (length != -1) {
            byte[] content = new byte[length];
            System.arraycopy(stream, offset[0], content, 0, length);
            o.setValue(content);
            offset[0] = offset[0] + length;
        }
    }

    private void decodeBMPSTRING(ASN1Object o, byte[] stream, int[] offset, int length) {
        if (length != -1) {
            byte[] content = new byte[length];
            System.arraycopy(stream, offset[0], content, 0, length);
            o.setValue(content);
            offset[0] = offset[0] + length;
        }
    }

    private void decodeOBJECTID(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length < 1) {
            throw new ASN1Exception("Wrong data (OBJECT ID) length");
        }
        int end = offset[0] + length;
        int n = offset[0];
        offset[0] = n + 1;
        byte v = stream[n];
        String content = Integer.toString(v / 40) + " ";
        content = content + Integer.toString(v % 40) + " ";
        while (offset[0] < end) {
            long l = 0L;
            while ((stream[offset[0]] & 0x80) != 0) {
                int n2 = offset[0];
                offset[0] = n2 + 1;
                l |= (long)(0x7F & stream[n2]);
                l <<= 7;
            }
            int n3 = offset[0];
            offset[0] = n3 + 1;
            content = content + Long.toString(l |= (long)(0x7F & stream[n3])) + " ";
        }
        if (offset[0] != end) {
            throw new ASN1Exception("Wrong data (OBJECT ID) length");
        }
        o.setValue(content.trim());
    }

    private void decodeUTCTime(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length != -1) {
            if (length < 11) {
                throw new ASN1Exception("Wrong data (UTCTime) length");
            }
            o.setValue(new String(stream, offset[0], length));
            offset[0] = offset[0] + length;
        }
    }

    private void decodeGeneralizedTime(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length != -1) {
            if (length < 11) {
                throw new ASN1Exception("Wrong data (UTCTime) length");
            }
            o.setValue(new String(stream, offset[0], length));
            offset[0] = offset[0] + length;
        }
    }

    private void decodePrintableString(ASN1Object o, byte[] stream, int[] offset, int length) {
        if (length != -1) {
            o.setValue(new String(stream, offset[0], length));
            offset[0] = offset[0] + length;
        }
    }

    private void decodeIA5String(ASN1Object o, byte[] stream, int[] offset, int length) {
        if (length != -1) {
            o.setValue(new String(stream, offset[0], length));
            offset[0] = offset[0] + length;
        }
    }

    private void decodeNULL(ASN1Object o, byte[] stream, int[] offset, int length) throws ASN1Exception {
        if (length != 0) {
            throw new ASN1Exception("Wrong data (NULL) length");
        }
        o.setValue("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeCONTEXT(ASN1Object o, byte[] stream, int[] offset, int length, int tag) throws ASN1Exception {
        Context obj = null;
        int start = offset[0];
        if (((tag &= 0x3F) & 0x20) == 0) {
            if (length < 0) {
                throw new ASN1Exception("Wrong length(ContextSpecific)");
            }
            byte[] data = new byte[length];
            System.arraycopy(stream, offset[0], data, 0, length);
            obj = new Context(tag, true, ASN1Object.create(ASN1Type.OCTET_STRING, data));
            offset[0] = offset[0] + length;
        } else {
            try {
                ASN1Object v = this.decode(stream, offset);
                if (length == -1) {
                    if (stream[offset[0]] != 0 || stream[offset[0] + 1] != 0) throw new ASN1Exception("wrong indefinite-length decoding");
                    offset[0] = offset[0] + 2;
                } else if (offset[0] != start + length) {
                    throw new ASN1Exception("wrong definite-length decoding");
                }
                obj = new Context(tag, false, v);
            }
            catch (ASN1Exception e) {
                offset[0] = start;
                ASN1Object v = ASN1Object.create(ASN1Type.SEQUENCE);
                this.decodeSEQUENCE(v, stream, offset, length);
                obj = new Context(tag, true, v);
            }
        }
        o.setValue(obj);
    }
}

