/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.jingle.FullJidAndSessionId;
import org.jivesoftware.smackx.jingle.JingleHandler;
import org.jivesoftware.smackx.jingle.JingleSessionHandler;
import org.jivesoftware.smackx.jingle.JingleTransportMethodManager;
import org.jivesoftware.smackx.jingle.JingleUtil;
import org.jivesoftware.smackx.jingle.element.Jingle;
import org.jivesoftware.smackx.jingle.element.JingleAction;
import org.jivesoftware.smackx.jingle.element.JingleContent;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.transports.jingle_ibb.JingleIBBTransportManager;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.JingleS5BTransportManager;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.FullJid;

public final class JingleManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(JingleManager.class.getName());
    private static final Map<XMPPConnection, JingleManager> INSTANCES = new WeakHashMap<XMPPConnection, JingleManager>();
    private static final ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final Map<String, JingleHandler> descriptionHandlers = new ConcurrentHashMap<String, JingleHandler>();
    private final Map<FullJidAndSessionId, JingleSessionHandler> jingleSessionHandlers = new ConcurrentHashMap<FullJidAndSessionId, JingleSessionHandler>();
    private final JingleUtil jutil;

    public static ExecutorService getThreadPool() {
        return threadPool;
    }

    public static synchronized JingleManager getInstanceFor(XMPPConnection connection) {
        JingleManager jingleManager = INSTANCES.get(connection);
        if (jingleManager == null) {
            jingleManager = new JingleManager(connection);
            INSTANCES.put(connection, jingleManager);
        }
        return jingleManager;
    }

    private JingleManager(XMPPConnection connection) {
        super(connection);
        this.jutil = new JingleUtil(connection);
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("jingle", "urn:xmpp:jingle:1", IQ.Type.set, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ iqRequest) {
                Jingle jingle = (Jingle)iqRequest;
                EntityFullJid fullFrom = jingle.getFrom().asFullJidOrThrow();
                String sid = jingle.getSid();
                FullJidAndSessionId fullJidAndSessionId = new FullJidAndSessionId(fullFrom, sid);
                JingleSessionHandler sessionHandler = (JingleSessionHandler)JingleManager.this.jingleSessionHandlers.get(fullJidAndSessionId);
                if (sessionHandler != null) {
                    return sessionHandler.handleJingleSessionRequest(jingle);
                }
                if (jingle.getAction() == JingleAction.session_initiate) {
                    JingleContent content = jingle.getContents().get(0);
                    JingleContentDescription description = content.getDescription();
                    JingleHandler jingleDescriptionHandler = (JingleHandler)JingleManager.this.descriptionHandlers.get(description.getNamespace());
                    if (jingleDescriptionHandler == null) {
                        LOGGER.log(Level.WARNING, "Unsupported Jingle application.");
                        return JingleManager.this.jutil.createSessionTerminateUnsupportedApplications(fullFrom, sid);
                    }
                    return jingleDescriptionHandler.handleJingleRequest(jingle);
                }
                LOGGER.log(Level.WARNING, "Unknown session.");
                return JingleManager.this.jutil.createErrorUnknownSession(jingle);
            }
        });
        JingleTransportMethodManager transportMethodManager = JingleTransportMethodManager.getInstanceFor(connection);
        transportMethodManager.registerTransportManager(JingleIBBTransportManager.getInstanceFor(connection));
        transportMethodManager.registerTransportManager(JingleS5BTransportManager.getInstanceFor(connection));
    }

    public JingleHandler registerDescriptionHandler(String namespace, JingleHandler handler) {
        return this.descriptionHandlers.put(namespace, handler);
    }

    public JingleSessionHandler registerJingleSessionHandler(FullJid otherJid, String sessionId, JingleSessionHandler sessionHandler) {
        FullJidAndSessionId fullJidAndSessionId = new FullJidAndSessionId(otherJid, sessionId);
        return this.jingleSessionHandlers.put(fullJidAndSessionId, sessionHandler);
    }

    public JingleSessionHandler unregisterJingleSessionHandler(FullJid otherJid, String sessionId, JingleSessionHandler sessionHandler) {
        FullJidAndSessionId fullJidAndSessionId = new FullJidAndSessionId(otherJid, sessionId);
        return this.jingleSessionHandlers.remove(fullJidAndSessionId);
    }

    public static String randomId() {
        return StringUtils.randomString(24);
    }
}

