/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.net.UnknownHostException;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.attribute.AddressAttribute;
import org.ice4j.message.Message;

public class XorMappedAddressAttribute
extends AddressAttribute {
    public static final String NAME = "XOR-MAPPED-ADDRESS";

    XorMappedAddressAttribute() {
        super(' ');
    }

    XorMappedAddressAttribute(char type) {
        super(type);
    }

    public static TransportAddress applyXor(TransportAddress address, byte[] transactionID) {
        TransportAddress xoredAdd;
        byte[] addressBytes = address.getAddressBytes();
        char port2 = (char)address.getPort();
        char portModifier = (char)(transactionID[0] << 8 & 0xFF00 | transactionID[1] & 0xFF);
        port2 = (char)(port2 ^ portModifier);
        for (int i = 0; i < addressBytes.length; ++i) {
            int n = i;
            addressBytes[n] = (byte)(addressBytes[n] ^ transactionID[i]);
        }
        try {
            xoredAdd = new TransportAddress(addressBytes, (int)port2, Transport.UDP);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        return xoredAdd;
    }

    public TransportAddress getAddress(byte[] transactionID) {
        byte[] xorMask = new byte[16];
        System.arraycopy(Message.MAGIC_COOKIE, 0, xorMask, 0, 4);
        System.arraycopy(transactionID, 0, xorMask, 4, 12);
        return this.applyXor(xorMask);
    }

    public TransportAddress applyXor(byte[] xorMask) {
        return XorMappedAddressAttribute.applyXor(this.getAddress(), xorMask);
    }

    public void setAddress(TransportAddress address, byte[] transactionID) {
        byte[] xorMask = new byte[16];
        System.arraycopy(Message.MAGIC_COOKIE, 0, xorMask, 0, 4);
        System.arraycopy(transactionID, 0, xorMask, 4, 12);
        TransportAddress xorAddress = XorMappedAddressAttribute.applyXor(address, xorMask);
        super.setAddress(xorAddress);
    }
}

