function(SDL_install_pdb TARGET DIRECTORY)
  get_property(type TARGET ${TARGET} PROPERTY TYPE)
  if(type MATCHES "^(SHARED_LIBRARY|EXECUTABLE)$")
    install(FILES $<TARGET_PDB_FILE:${TARGET}> DESTINATION "${DIRECTORY}" OPTIONAL)
  elseif(type STREQUAL "STATIC_LIBRARY")
    # FIXME: Use $<TARGET_COMPILE_PDB_FILE:${TARGET} once it becomes available (https://gitlab.kitware.com/cmake/cmake/-/issues/25244)
    if(CMAKE_GENERATOR MATCHES "^Visual Studio.*")
      install(CODE "file(INSTALL DESTINATION \"\${CMAKE_INSTALL_PREFIX}/${DIRECTORY}\" TYPE FILE OPTIONAL FILES \"${CMAKE_CURRENT_BINARY_DIR}/\${CMAKE_INSTALL_CONFIG_NAME}/${TARGET}.pdb\")")
    else()
      install(CODE "file(INSTALL DESTINATION \"\${CMAKE_INSTALL_PREFIX}/${DIRECTORY}\" TYPE FILE OPTIONAL FILES \"${CMAKE_CURRENT_BINARY_DIR}/CMakeFiles/${TARGET}.dir/${TARGET}.pdb\")")
    endif()
  endif()
endfunction()
