% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/churn.R
\docType{data}
\name{mlc_churn}
\alias{mlc_churn}
\title{Customer churn data}
\source{
Originally at \verb{http://www.sgi.com/tech/mlc/}
}
\value{
\item{mlc_churn}{a tibble}
}
\description{
A data set from the MLC++ machine learning software for modeling customer
churn. There are 19 predictors, mostly numeric: \code{state} (categorical),
\code{account_length} \code{area_code} \code{international_plan} (yes/no),
\code{voice_mail_plan} (yes/no), \code{number_vmail_messages}
\code{total_day_minutes} \code{total_day_calls} \code{total_day_charge}
\code{total_eve_minutes} \code{total_eve_calls} \code{total_eve_charge}
\code{total_night_minutes} \code{total_night_calls}
\code{total_night_charge} \code{total_intl_minutes}
\code{total_intl_calls} \code{total_intl_charge}, and
\code{number_customer_service_calls}.
}
\details{
The outcome is contained in a column called \code{churn} (also yes/no).
A note in one of the source files states that the data are "artificial based
on claims similar to real world".
}
\examples{
data(mlc_churn)
str(mlc_churn)
}
\keyword{datasets}
