% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-vline.R
\name{scale_vline}
\alias{scale_vline_linetype}
\alias{scale_vline_width_continuous}
\alias{scale_vline_colour_hue}
\alias{scale_vline_color_hue}
\alias{scale_vline_colour_gradient}
\alias{scale_vline_color_gradient}
\alias{scale_vline_linetype_discrete}
\alias{scale_vline_color_discrete}
\alias{scale_vline_colour_discrete}
\alias{scale_vline_color_continuous}
\alias{scale_vline_colour_continuous}
\title{Scales for vline aesthetics}
\description{
These are various scales that can be applied to vline aesthetics, such as
\code{vline_color}, \code{vline_width}, \code{vline_linetype}. The individual scales all have the
same usage as existing standard ggplot2 scales, only the name differs.
}
\examples{
library(ggplot2)

# default scales
ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species, color = Species)) +
  geom_density_ridges(
    aes(vline_color = Species, vline_linetype = Species),
    alpha = .4, quantile_lines = TRUE
  ) +
  theme_ridges()

# modified scales
ggplot(iris, aes(x=Sepal.Length, y=Species, fill = Species, color = Species)) +
  geom_density_ridges(
    aes(vline_color = Species),
    alpha = .4, quantile_lines = TRUE
  ) +
  scale_fill_hue(l = 50) +
  scale_vline_color_hue(l = 30) +
  theme_ridges()
}
\seealso{
See \code{\link[=scale_point_color_hue]{scale_point_color_hue()}} for specific scales for point aesthetics
and \code{\link[ggplot2:scale_manual]{ggplot2::scale_discrete_manual()}} for a general discrete scale.
}
