% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_text}
\alias{ggally_text}
\title{Text plot}
\usage{
ggally_text(
  label,
  mapping = ggplot2::aes(color = I("black")),
  xP = 0.5,
  yP = 0.5,
  xrange = c(0, 1),
  yrange = c(0, 1),
  ...
)
}
\arguments{
\item{label}{text that you want to appear}

\item{mapping}{aesthetics that don't relate to position (such as color)}

\item{xP}{horizontal position percentage}

\item{yP}{vertical position percentage}

\item{xrange}{range of the data around it.  Only nice to have if plotting in a matrix}

\item{yrange}{range of the data around it.  Only nice to have if plotting in a matrix}

\item{...}{other arguments for geom_text}
}
\description{
Plot text for a plot.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

p_(ggally_text("Example 1"))
p_(ggally_text("Example\nTwo", mapping = ggplot2::aes(size = 15), color = I("red")))
}
\author{
Barret Schloerke
}
\keyword{hplot}
