# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.computeschedule import ComputeScheduleMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeScheduleMgmtOccurrencesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeScheduleMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_occurrences_get(self, resource_group):
        response = self.client.occurrences.get(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            occurrence_id="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_occurrences_list_by_scheduled_action(self, resource_group):
        response = self.client.occurrences.list_by_scheduled_action(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_occurrences_list_resources(self, resource_group):
        response = self.client.occurrences.list_resources(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            occurrence_id="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_occurrences_cancel(self, resource_group):
        response = self.client.occurrences.cancel(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            occurrence_id="str",
            body={"resourceIds": ["str"]},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_occurrences_begin_delay(self, resource_group):
        response = self.client.occurrences.begin_delay(
            resource_group_name=resource_group.name,
            scheduled_action_name="str",
            occurrence_id="str",
            body={"delay": "2020-02-20 00:00:00", "resourceIds": ["str"]},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
